% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_esteq.R
\name{qgcomp.emm.glm.ee}
\alias{qgcomp.emm.glm.ee}
\alias{qgcomp.emm.ee}
\title{EMM for Quantile g-computation for continuous, binary, and count outcomes under linearity/additivity}
\usage{
qgcomp.emm.glm.ee(
  f,
  data,
  expnms = NULL,
  emmvar = NULL,
  q = 4,
  breaks = NULL,
  id = NULL,
  weights,
  offset = NULL,
  alpha = 0.05,
  rr = TRUE,
  degree = 1,
  includeX = TRUE,
  verbose = TRUE,
  errcheck = TRUE,
  ...
)

qgcomp.emm.ee(
  f,
  data,
  expnms = NULL,
  emmvar = NULL,
  q = 4,
  breaks = NULL,
  id = NULL,
  weights,
  offset = NULL,
  alpha = 0.05,
  rr = TRUE,
  degree = 1,
  includeX = TRUE,
  verbose = TRUE,
  errcheck = TRUE,
  ...
)
}
\arguments{
\item{f}{R style formula}

\item{data}{data frame}

\item{expnms}{character vector of exposures of interest}

\item{emmvar}{(character) name of effect measure modifier in dataset (if categorical, must be coded as a factor variable)}

\item{q}{NULL or number of quantiles used to create quantile indicator variables
representing the exposure variables. If NULL, then gcomp proceeds with un-transformed
version of exposures in the input datasets (useful if data are already transformed,
or for performing standard g-computation)}

\item{breaks}{(optional) NULL, or a list of (equal length) numeric vectors that
characterize the minimum value of each category for which to
break up the variables named in expnms. This is an alternative to using 'q'
to define cutpoints.}

\item{id}{(optional) NULL, or variable name indexing individual units of
observation (only needed if analyzing data with multiple observations per
id/cluster). Note that qgcomp.noboot will not produce cluster-appropriate
standard errors (this parameter is essentially ignored in qgcomp.noboot).
Qgcomp.boot can be used for this, which will use bootstrap
sampling of clusters/individuals to estimate cluster-appropriate standard
errors via bootstrapping.}

\item{weights}{"case weights" or sampling weights - a vector of weights representing the contribution of each observation to the overall fit}

\item{offset}{Model offset term on individual basis: not yet implemented
\code{\link[stats]{glm}} or \code{\link[arm]{bayesglm}}}

\item{alpha}{alpha level for confidence limit calculation}

\item{rr}{(logical, default=TRUE) estimate a risk ratio from the MSM when using an underlying logistic model}

\item{degree}{polynomial degree for non-linearity of MSM (values other than 1 are not supported, currently)}

\item{includeX}{(logical, default=TRUE) include design matrixes in the output?}

\item{verbose}{(logical, default=TRUE) include informative messages}

\item{errcheck}{(logical, default=TRUE) include some basic error checking. Slightly
faster if set to false (but be sure you understand risks)}

\item{...}{arguments to glm (e.g. family)}
}
\value{
a eeqgcompfit/qgcompemmfit/qgcompfit/list object, which contains information about the effect
measure of interest (psi) and associated variance (var.psi), as well
as information on the conditional/underlying model fit (fit) and the marginal structural model fit (msmfit).
}
\description{
This function estimates a dose-response parameter representing a one quantile
increase in a set of exposures of interest at levels of a binary, factor, or continuous covariate.
This allows
testing of statistical interaction as well as estimation of stratum specific effects.
This model estimates the parameters of a marginal
structural model (MSM) based on g-computation with quantized exposures.
Note: this function allows clustering of data and/or sampling weights and yields cluster-robust standard
errors for all estimates

Estimating equation methodology is used as the underlying estimation scheme. This allows that observations can be correlated, and is fundementally identical to some implementations of "generalized estimating equations" or GEE. Thus, it allows for a more general set of longitudinal data structures than does the qgcomp.glm.noboot function, because it allows that the outcome can vary over time within an individual. Interpretation of parameters is similar to that of a GEE: this function yields population average estimates of the effect of exposure over time.
}
\examples{
set.seed(50)
# linear model, binary modifier
dat <- data.frame(y=runif(50), x1=runif(50), x2=runif(50),
  z=rbinom(50, 1, 0.5), r=rbinom(50, 1, 0.5))
(qfit <- qgcomp.emm.glm.noboot(f=y ~ z + x1 + x2, emmvar="z",
  expnms = c('x1', 'x2'), data=dat, q=2, family=gaussian()))
(qfitee <- qgcomp.emm.glm.ee(f=y ~ z + x1 + x2, emmvar="z",
  expnms = c('x1', 'x2'), data=dat, q=2, family=gaussian()))
# logistic model, continuous modifier
dat2 <- data.frame(y=rbinom(50, 1, 0.5), x1=runif(50), x2=runif(50),
  z=runif(50), r=rbinom(50, 1, 0.5))
(qfit2 <- qgcomp.emm.glm.noboot(f=y ~ z + x1 + x2, emmvar="z",
  expnms = c('x1', 'x2'), data=dat2, q=2, family=binomial()))
(qfit2ee <- qgcomp.emm.glm.ee(f=y ~ z + x1 + x2, emmvar="z",
  expnms = c('x1', 'x2'), data=dat2, q=2, family=binomial(), rr=FALSE))
# Note under rr = TRUE that the risk ratio will be reported in the MSM results
(qfit2eerr <- qgcomp.emm.glm.ee(f=y ~ z + x1 + x2, emmvar="z",
  expnms = c('x1', 'x2'), data=dat2, q=2, family=binomial(), rr=TRUE))
# linear model, factor modifier
dat <- data.frame(y=runif(150), x1=runif(150), x2=runif(150),
  r=rbinom(150, 1, 0.5), z=sample(c(1, 2, 3), 150, replace=TRUE))
#note need to declare factor
dat$zfact = as.factor(dat$z)
# this can fail if the model is unidentified (e.g. z and zfact are included in the model)
(qfit <- qgcomp.emm.glm.noboot(f=y ~ zfact + x1 + x2, emmvar="zfact",
  expnms = c('x1', 'x2'), data=dat, q=2, family=gaussian()))
(qfitee <- qgcomp.emm.glm.ee(f=y ~ zfact + x1 + x2, emmvar="zfact",
  expnms = c('x1', 'x2'), data=dat, q=2, family=gaussian()))
library(qgcomp)
# standard qgcomp model without interaction
(qfitee_noemm <- qgcomp.glm.ee(f=y ~ zfact + x1 + x2,
  expnms = c('x1', 'x2'), data=dat, q=2, family=gaussian()))
  qfitee_noemm$fit # underlying fit
# global test for interaction
anova(qfitee, qfitee_noemm)
# get stratified effect estimates:
getstrateffects(qfitee, emmval=1)
getstrateffects(qfitee, emmval=2)
getstrateffects(qfitee, emmval=3)
dat$rfact = as.factor(dat$r)
(qfiteer <- qgcomp.emm.glm.ee(f=y ~ zfact + x1 + x2 + r, emmvar="zfact",
  expnms = c('x1', 'x2'), data=dat, q=2, family=gaussian()))
 # factor as a confounder, also works if the modifier is not in the model
(qfiteerr2 <- qgcomp.emm.glm.ee(f=y ~  x1 + x2 + rfact, emmvar="zfact",
  expnms = c('x1', 'x2'), data=dat, q=2, family=gaussian()))
getstrateffects(qfiteerr2, emmval=2)
getjointeffects(qfiteerr2, emmval=2)
modelbound(qfiteerr2, emmval=2)
pointwisebound(qfiteerr2, emmval=2)
(qfitee <- qgcomp.glm.ee(f=y ~ zfact + x1 + x2, emmvar="zfact",
  expnms = c('x1', 'x2'), data=dat, q=10, degree=2, family=gaussian()))
(qfitee <- qgcomp.emm.glm.ee(f=y ~ zfact + x1 + x2, emmvar="zfact",
  expnms = c('x1', 'x2'), data=dat, q=10, degree=2, family=gaussian()))
}
\seealso{
\code{\link[qgcomp]{qgcomp.noboot}}
}
\concept{variance mixtures}
