% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/htruncdf.R
\name{htruncdf}
\alias{htruncdf}
\alias{truncdf}
\alias{ltruncdf}
\alias{qview}
\alias{lview}
\title{Dataframe Viewing}
\usage{
htruncdf(dataframe, n = 10, width = 10, ...)

truncdf(dataframe, end = 10, begin = 1)

ltruncdf(dat.list, n = 6, width = 10, ...)

qview(dataframe, ...)

lview(x, print = TRUE)
}
\arguments{
\item{dataframe}{A data.frame object.}

\item{n}{Number of rows to display.}

\item{width}{The width of the columns to be displayed.}

\item{end}{The last character to be displayed (width).}

\item{begin}{The first character to be displayed (width).}

\item{dat.list}{A list of data.frame objects.}

\item{x}{A class qdap object that is a list which prints as a dataframe.}

\item{print}{logical.  If \code{TRUE} prints to the console.}

\item{\ldots}{Other arguments passed to \code{\link[qdap]{htruncdf}} 
(\code{\link[qdap]{qview}}; \code{\link[qdap]{ltruncdf}}) or 
\code{\link[utils]{head}} (\code{\link[qdap]{htruncdf}}).}
}
\value{
\code{htrundf} - returns n number of rows of a truncated dataframe.

\code{trundf} - returns a truncated dataframe.

\code{ltruncdf} - returns a list of n number of rows of a truncated 
dataframes.

\code{qview} - returns a dataframe head with summary statistics.

\code{lview} - prints a list of the qdap object and invisibly returns 
the unclassed object.
}
\description{
\code{htruncdf} - Convenience function to view the head of a truncated 
dataframe.

\code{truncdf} - Convenience function to view a truncated dataframe.

\code{ltruncdf} - Convenience function to view the head of a list of 
truncated dataframes.

\code{qview} - Convenience function to view a summary and head of a dataframe.

\code{lview} - Convenience function to view the list (list view) of qdap 
objects that have print methods that print a single dataframe.
}
\examples{
\dontrun{
truncdf(raj[1:10, ])
truncdf(raj[1:10, ], 40)
htruncdf(raj)
htruncdf(raj, 20)
htruncdf(raj, ,20)
ltruncdf(rajPOS, width = 4)
qview(raj)
qview(CO2)
lview(question_type(DATA.SPLIT$state, DATA.SPLIT$person))
lview(rajPOS)
lview(lm(mpg~hp, data = mtcars))
}
}
\seealso{
\code{\link[utils]{head}}
}
