% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexical_classification.R
\name{Animate.lexical_classification}
\alias{Animate.lexical_classification}
\title{Animate Formality}
\usage{
\method{Animate}{lexical_classification}(x, type = "network",
  content = "red", functional = "yellow", edge.constant,
  wc.time = TRUE, time.constant = 2, title = NULL, digits = 2,
  current.color = "black", current.speaker.color = NULL,
  non.speaker.color = NA, missing.color = "purple",
  all.color.line = "red", width = 65,
  function.words = qdapDictionaries::function.words, left = "<<",
  right = ">>", coord = c(0, 0.5), just = c(0, 0.5), ...)
}
\arguments{
\item{x}{A \code{\link[qdap]{lexical_classification}} object.}

\item{type}{Character string of either \code{"network"} (as a network 
plot), \code{"bar"} (as a bar plot), or \code{"text"} (as a simple 
colored text plot).}

\item{content}{The color to use for 100\% lexical_classification (purely 
content).}

\item{functional}{The color to use for 0\% lexical_classification (purely 
functional).}

\item{edge.constant}{A constant to multiple edge width by.}

\item{wc.time}{logical.  If \code{TRUE} weights duration of frame by word 
count.}

\item{time.constant}{A constant to divide the maximum word count by.  Time
is calculated by `round(exp(WORD COUNT/(max(WORD COUNT)/time.constant)))`.  
Therefore a larger constant will make the difference between the large and 
small word counts greater.}

\item{title}{The title to apply to the animated image(s).}

\item{digits}{The number of digits to use in the current turn of talk's
content rate.}

\item{current.color}{The color to use for the current turn of talk's 
content rate.}

\item{current.speaker.color}{The color for the current speaker.}

\item{non.speaker.color}{The color for the speakers not currently speaking.}

\item{missing.color}{The color to use in a network plot for edges 
corresponding to missing text data.  Use \code{\link[stats]{na.omit}} before 
hand to remove the missing values all together.}

\item{all.color.line}{The color to use for the total average discourse 
content rate.}

\item{width}{The width to break text at if \code{type = "text"}.}

\item{function.words}{A vector of function words.  Default is 
\code{\link[qdapDictionaries]{function.words}}.}

\item{left}{A left bound to wrap content words with if \code{type = "text"}.}

\item{right}{A right bound to wrap content words with  if \code{type = "text"}.}

\item{coord}{The x/y coordinate to plot the test if \code{type = "text"}.}

\item{just}{The \code{hjust} and \code{vjust} values to use for the text if 
\code{type = "text"}.}

\item{\ldots}{Other arguments passed to \code{\link[qdap]{discourse_map}} or
\code{\link[ggplot2]{annotate}} if \code{type = "text"}.}
}
\description{
\code{Animate.lexical_classification} - Animate a 
\code{\link[qdap]{lexical_classification}} object.
}
\details{
lexical_classification Method for Animate
}
\note{
The width of edges is based on words counts on that edge until that 
moment divided by total number of words used until that moment.  Thicker 
edges tend to thin as time passes.  The actual duration the current edge 
stays as the \code{current.color} is based on word counts for that particular 
flow of dialogue divided by total dialogue (words) used.  The edge label is
the current content rate for that turn of talk (an aggregation of 
the sub sentences of the current turn of talk).  The coloring of the current 
edge content rate is produced at th sentence level, therefor a label may 
indicate a more content laden current turn of talk, while the coloring may 
indicate a functional laden average of sentences.  Coloring is based on 
percentage of conent words.
}
