% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddG.R
\name{ddG.profile}
\alias{ddG.profile}
\title{Contribution of a given position to changes in stability}
\usage{
ddG.profile(prot, ch, pos, pH = 7, Te = 25)
}
\arguments{
\item{prot}{either the 4-letter identifier of a PDB structure, or the amino acid sequence (one letter amino acid code) of a protein.}

\item{ch}{a letter identifying the chain of interest.}

\item{pos}{the position, in the primary structure, of the residue to be mutated.}

\item{pH}{a numeric value between 0 and 14.}

\item{Te}{a numeric value indicating the temperature in degrees Celsius.}
}
\value{
The function returns a dataframe with the DDG values (kcal/mol) for each alternative amino acid, and a barplot grouping the amino acids according to their physicochemical nature.
}
\description{
Represents the sensitivity of a given position to changes in stability of a protein (DDG).
}
\details{
It must be remembered that DDG > 0 implies destabilizing change and DDG > 0 implies a stabilizing change.
}
\examples{
\dontrun{ddG.profile(prot = '1pga', ch = 'A', pos = 27)}
}
\seealso{
foldx.mut(), imutant()
}
\author{
Juan Carlos Aledo
}
