% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cal-estimate-beta.R
\name{cal_estimate_beta}
\alias{cal_estimate_beta}
\alias{cal_estimate_beta.data.frame}
\alias{cal_estimate_beta.tune_results}
\alias{cal_estimate_beta.grouped_df}
\title{Uses a Beta calibration model to calculate new probabilities}
\usage{
cal_estimate_beta(
  .data,
  truth = NULL,
  shape_params = 2,
  location_params = 1,
  estimate = dplyr::starts_with(".pred_"),
  parameters = NULL,
  ...
)

\method{cal_estimate_beta}{data.frame}(
  .data,
  truth = NULL,
  shape_params = 2,
  location_params = 1,
  estimate = dplyr::starts_with(".pred_"),
  parameters = NULL,
  ...,
  .by = NULL
)

\method{cal_estimate_beta}{tune_results}(
  .data,
  truth = NULL,
  shape_params = 2,
  location_params = 1,
  estimate = dplyr::starts_with(".pred_"),
  parameters = NULL,
  ...
)

\method{cal_estimate_beta}{grouped_df}(
  .data,
  truth = NULL,
  shape_params = 2,
  location_params = 1,
  estimate = NULL,
  parameters = NULL,
  ...
)
}
\arguments{
\item{.data}{An ungrouped \code{data.frame} object, or \code{tune_results} object,
that contains predictions and probability columns.}

\item{truth}{The column identifier for the true class results
(that is a factor). This should be an unquoted column name.}

\item{shape_params}{Number of shape parameters to use. Accepted values are
1 and 2. Defaults to 2.}

\item{location_params}{Number of location parameters to use. Accepted values
1 and 0. Defaults to 1.}

\item{estimate}{A vector of column identifiers, or one of \code{dplyr} selector
functions to choose which variables contains the class probabilities. It
defaults to the prefix used by tidymodels (\code{.pred_}). The order of the
identifiers will be considered the same as the order of the levels of the
\code{truth} variable.}

\item{parameters}{(Optional)  An optional tibble of tuning parameter values
that can be used to filter the predicted values before processing. Applies
only to \code{tune_results} objects.}

\item{...}{Additional arguments passed to the models or routines used to
calculate the new probabilities.}

\item{.by}{The column identifier for the grouping variable. This should be
a single unquoted column name that selects a qualitative variable for
grouping. Default to \code{NULL}. When \code{.by = NULL} no grouping will take place.}
}
\description{
Uses a Beta calibration model to calculate new probabilities
}
\details{
This function uses the \code{\link[betacal:beta_calibration]{betacal::beta_calibration()}} function, and
retains the resulting model.
}
\section{Multiclass Extension}{


This method is designed to work with two classes. For multiclass, it creates
a set of "one versus all" calibrations for each class. After they are
applied to the data, the probability estimates are re-normalized to add to
one. This final step might compromise the calibration.
}

\examples{
if (rlang::is_installed("betacal")) {
 # It will automatically identify the probability columns
  # if passed a model fitted with tidymodels
  cal_estimate_beta(segment_logistic, Class)
}
}
\references{
Meelis Kull, Telmo M. Silva Filho, Peter Flach "Beyond sigmoids:
How to obtain well-calibrated probabilities from binary classifiers with beta
calibration," \emph{Electronic Journal of Statistics} 11(2), 5052-5080, (2017)
}
\seealso{
\url{https://www.tidymodels.org/learn/models/calibration/},
\code{\link[=cal_validate_beta]{cal_validate_beta()}}
}
