% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/pplot.lorenz.r
\name{pplot.lorenz}
\alias{pplot.lorenz}
\alias{precintcon.plot.lorenz}
\title{Plot Lorenz's curve}
\usage{
pplot.lorenz(\dots, interval = 1, grouped = FALSE,
xlab = expression(sum(n[i]), i==1), ylab = expression(sum(P[i]), i==1),
legend.title = "Legend", legend = NULL, fontsize = 10,
axis.text.color = "black", export = FALSE, export.name = "lorenz_plot.png",
width = 8.6, height = 7.5, units = "cm")
}
\arguments{
\item{interval}{the interval in millimeters applied for calculating the
Lorenz's curve. (Default value: 1)}

\item{grouped}{the logical value for defining whether all series should
be plotted in the same graph or not. (Default value: FALSE)}

\item{xlab}{the text for the x axis.
(Default value: expression(sum(n[i]), i==1)}

\item{ylab}{the text for the y axis.
(Default value: expression(sum(P[i]), i==1))}

\item{legend.title}{the text for the legend title.
(Default value: "Legend")}

\item{legend}{the text vector for the legend items.
If NULL the legends will be equals to the variable names. (Default value: NULL)}

\item{fontsize}{the font size value in pt. (Default value: 10)}

\item{axis.text.color}{the legend colors. (Default value: "black")}

\item{export}{the logical value for defining whether the graph should be
export to a file or not. (Default value: FALSE)}

\item{export.name}{the text for defining the exported file name. It is only
used if export = TRUE. (Default value: "histogram_plot.png")}

\item{width}{the number for defining the exported graph width. It is only
used if export = TRUE. (Default value: 10)}

\item{height}{the number for defining the exported graph height. It is only
used if export = TRUE. (Default value: 10)}

\item{units}{the text for defining the units of the height and width
parameters. It is only used if export = TRUE. (Default value: "cm")}

\item{\dots}{a set of daily precipitation series.}
}
\description{
Plots the Lorenz's curve of a precipitation serie.
}
\examples{
##
# Loading the daily precipitation serie.
data(daily)

##
# Performing the a set of statistical analysis
pplot.lorenz(daily, interval = 1)
}
\author{
Lucas Venezian Povoa \email{lucasvenez@gmail.com}
}
\seealso{
\code{\link{ci}}
\code{\link{read.data}}
\code{\link{as.daily}}
}
\keyword{curve}
\keyword{lorenz's}
\keyword{precipitation}

