% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IsReflexive.R
\name{IsReflexive}
\alias{IsReflexive}
\title{Checking binary relation reflexivity.}
\usage{
IsReflexive(set, rel)
}
\arguments{
\item{set}{A list of strings (the names of the elements of the set, on which the binary relation is defined).}

\item{rel}{A two-columns character matrix, each row comprising an element (pair) of the binary relation.}
}
\value{
A boolean value.
}
\description{
Checks whether the input binary relation is reflexive.
}
\examples{
set<-c("a", "b", "c", "d", "e")

rel <- matrix(c(
  "a", "b",
  "c", "b",
  "b", "d",
  "a", "a",
  "b", "b",
  "c", "c"
), ncol = 2, byrow = TRUE)

chk <- IsReflexive(set, rel)

}
