#ifndef rwrapper_hpp
#define rwrapper_hpp

#include <string>
#ifndef R_NO_REMAP
#define R_NO_REMAP
#endif
#include <Rinternals.h>
#include <R.h>
/*
 #include <R.h>
#include <R_ext/Rdynload.h>
#include <R_ext/Error.h>
#include <R_ext/Print.h>
#include <R_ext/Parse.h>
*/


// ***********************************************
// ***********************************************
// ***********************************************

enum class PointerTypes {poset, legenerator};

SEXP Proteggi(SEXP s, int& conta);
void forward_exception_to_r(const std::string message);
void forward_warning_to_r(const std::string message);


extern "C" {
SEXP isReflexive(SEXP elements_r, SEXP comparabilities_r);
SEXP isSymmetric(SEXP comparabilities_r);
SEXP isAntisymmetric(SEXP comparabilities_r);
SEXP isTransitive(SEXP comparabilities_r);
SEXP TransitiveClosure(SEXP comparabilities_r);
SEXP ReflexiveClosure(SEXP elements_r, SEXP comparabilities_r);
SEXP isPreorder(SEXP elements_r, SEXP comparabilities_r);
SEXP isPartialOrder(SEXP elements_r, SEXP comparabilities_r);
SEXP BuildPOSet(SEXP elements, SEXP comparabilities);
SEXP BuildLinearPOSet(SEXP elements);
SEXP BuildProductPOSet(SEXP posets_r);
SEXP BuildLexicographicProductPOSet(SEXP posets_r);
SEXP BuildIntersectionPOSet(SEXP posets_r);
SEXP BuildLinearSumPOSet(SEXP posets_r);
SEXP BuildDisjointSumPOSet(SEXP posets_r);
SEXP BuildLiftingPOSet(SEXP poset_r, SEXP new_element_r);
SEXP BuildBucketPOSet(SEXP elements, SEXP comparabilities);
SEXP BuildBinaryVariablePOSet(SEXP variables);
SEXP BuildFencePOSet(SEXP elements_r, SEXP orientation_r);
SEXP BuildCrownPOSet(SEXP elements_1_r, SEXP elements_2_r);
SEXP BuildDualPOSet(SEXP poset_r);
SEXP Elements(SEXP poset_r);
SEXP IncidenceMatrix(SEXP poset_r);
SEXP OrderRelation(SEXP poset_r);
SEXP IsDominatedBy(SEXP poset_r, SEXP v1, SEXP v2);
SEXP Dominates(SEXP poset_r, SEXP v1, SEXP v2);
SEXP IsComparableWith(SEXP poset_r, SEXP v1, SEXP v2);
SEXP IsIncomparableWith(SEXP poset_r, SEXP v1, SEXP v2);
SEXP UpsetOf(SEXP poset_r, SEXP insieme);
SEXP IsUpset(SEXP poset_r, SEXP insieme);
SEXP IsDownset(SEXP poset_r, SEXP insieme);
SEXP DownsetOf(SEXP poset_r, SEXP insieme);
SEXP ComparabilitySetOf(SEXP poset_r, SEXP elemento);
SEXP IncomparabilitySetOf(SEXP poset_r, SEXP elemento);
SEXP Maximal(SEXP poset_r);
SEXP Minimal(SEXP poset_r);
SEXP IsMaximal(SEXP poset_r, SEXP elemento);
SEXP IsMinimal(SEXP poset_r, SEXP elemento);
SEXP Meet(SEXP poset_r, SEXP insieme_r);
SEXP Join(SEXP poset_r, SEXP insieme_r);
SEXP CoverRelation(SEXP poset_r);
SEXP CoverMatrix(SEXP poset_r);
SEXP Incomparabilities(SEXP poset_r);
SEXP IsExtensionOf(SEXP poset_r_1, SEXP poset_r_2);
SEXP BuildLEGenerator(SEXP poset_r);
SEXP BuildBubleyDyerLEGenerator(SEXP poset_r, SEXP arg);
SEXP LEGBubleyDyerGet(SEXP generator_r, SEXP from_start_r, SEXP quante_r, SEXP errore_r, SEXP output_ogni_in_sec_r);
SEXP LEGGet(SEXP generator_r, SEXP from_start_r, SEXP quante_r, SEXP output_ogni_in_sec_r);
SEXP ExactMRP(SEXP poset_r, SEXP output_ogni_in_sec_r);
SEXP BuildBubleyDyerMRPGenerator(SEXP poset_r, SEXP seed_r);
SEXP BubleyDyerMRP(SEXP bubley_dyer_r, SEXP quante_r, SEXP errore_r, SEXP output_ogni_in_sec_r);
SEXP ExactEvaluation(SEXP poset_r, SEXP output_ogni_in_sec_r, SEXP functions_r);
SEXP BuildBubleyDyerEvaluationGenerator(SEXP poset_r, SEXP seed_r, SEXP functions_r);
SEXP BubleyDyerEvaluation(SEXP generator_r, SEXP quante_r, SEXP errore_r, SEXP output_ogni_in_sec_r);
SEXP BruggemannLercheSorensenDominance(SEXP poset_r);

SEXP FuzzySeparation(SEXP dominance_matrix_r, SEXP quale_r, SEXP tnorm_r, SEXP tconorm_r);
SEXP FuzzyInBetweenness(SEXP dominance_matrix_r, SEXP tnorm_r, SEXP tconorm_r, SEXP quali_r);
SEXP ExactSeparation(SEXP poset_r, SEXP output_ogni_in_sec_r, SEXP quali_r);
SEXP RunLexSeparation(SEXP numero_variabili_r, SEXP modalita_r);
SEXP RunLexMRP(SEXP modalita_r);
SEXP BuildBubleyDyerSeparationGenerator(SEXP poset_r, SEXP seed_r, SEXP quali_r);
SEXP BubleyDyerSeparation(SEXP generator_r, SEXP quante_r, SEXP errore_r, SEXP output_ogni_in_sec_r);
SEXP RunDimensionalityReduction(SEXP profile_r, SEXP weights_r, SEXP loss_r, SEXP output_ogni_in_sec_r, SEXP thread_percentage_r);

}



#endif /* poset_wrapper_hpp */
