% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_split.R
\name{group_split}
\alias{group_split}
\alias{group_keys}
\title{Split data.frame by groups}
\usage{
group_split(.data, ..., .keep = TRUE)

group_keys(.data)
}
\arguments{
\item{.data}{A \code{data.frame}.}

\item{...}{Grouping specification, forwarded to \code{\link[=group_by]{group_by()}}.}

\item{.keep}{\code{logical(1)}. Should the grouping columns be kept (default: TRUE)?}
}
\value{
\itemize{
\item \code{group_split()} returns a list of \code{data.frame}s. Each \code{data.frame} contains the rows of \code{.data} with the associated
group and all the columns, including the grouping variables.
\item \code{group_keys()} returns a \code{data.frame} with one row per group, and one column per grouping variable
}
}
\description{
\code{group_split()} works like \code{\link[base:split]{base::split()}} but
\itemize{
\item it uses the grouping structure from \code{\link[=group_by]{group_by()}} and is therefore subject to the data mask
\item it does not name the elements of the list based on the grouping as this typically loses information and is
confusing
}
}
\details{
\strong{Grouped \code{data.frame}s:}

The primary use case for \code{group_split()} is with already groups \code{data.frame}s, typically a result of \code{\link[=group_by]{group_by()}}. In
this case, \code{group_split()} only uses the first argument, the grouped \code{data.frame}, and warns when \code{...} is used.

Because some of these groups may be empty, it is best paired with \code{group_keys()} which identifies the representatives
of each grouping variable for the group.

\strong{Ungrouped \code{data.frame}s:}

When used on ungrouped \code{data.frame}s, \code{group_split()} forwards the \code{...} to \code{group_by()} before the split, therefore
the \code{...} are subject to the data mask.
}
\examples{
# Grouped data.frames:
mtcars \%>\% group_by(cyl, am) \%>\% group_split()
mtcars \%>\% group_by(cyl, am) \%>\% group_split(.keep = FALSE)
mtcars \%>\% group_by(cyl, am) \%>\% group_keys()

# Ungrouped data.frames:
mtcars \%>\% group_split(am, cyl)

}
\seealso{
\code{\link[=group_by]{group_by()}}
}
