% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_ABC.R
\name{regABC}
\alias{regABC}
\title{Parameter estimation with Approximate Bayesian Computation using local linear
regression}
\usage{
regABC(rej, parameter, tol = 1, simple = FALSE)
}
\arguments{
\item{rej}{is a list with the results of the rejection sampling algorithm.
The output of the \code{\link[=rejABC]{rejABC()}} function is the ideal input here.}

\item{parameter}{is a parameter vector (long vector of numbers from the
simulations). Each vector entry should correspond to a different
simulation. This is the dependent variable for the regression.}

\item{tol}{is the tolerance rate, indicating the required proportion of
points accepted nearest the target values. Note that the default value here
is 1 because all points accepted in the rejection step should be used for
the regression.}

\item{simple}{logical, if TRUE a simplified output with only the essential
information will be produced. If FALSE (default) the output will contain
more information.}
}
\value{
a list with the results from the regression correction

\item{adjusted}{regression adjusted parameter values.}

\item{unadjusted}{parameter estimates obtained with the rejection
sampling.}

\item{wt}{regression weights.}

\item{ss}{set of accepted summary statistics from the simulations.}

\item{predmean}{estimates of the posterior mean for each parameter.}

\item{fv}{fitted value from the regression.}
}
\description{
This function performs multivariate parameter estimation based on summary
statistics using an Approximate Bayesian Computation (ABC) algorithm. The
algorithm used here is the local linear regression algorithm.
}
\details{
Note that to use this function, the usual steps of ABC parameter estimation
have to be performed. Briefly, data should have been simulated based on
random draws from the prior distributions of the parameters of interest and a
set of summary statistics should have been calculated from that data. The
same set of summary statistics should have been calculated from the observed
data to be used as the target for parameter inference. A previous rejection
sampling step should also have been performed, where parameter values were
accepted if the Euclidean distance between the set of summary statistics
computed from the simulated data and the set of summary statistics computed
from the observed data was sufficiently small. Then, the output of the
rejection step is used as the input for this function and a local linear
regression method is used to correct for the imperfect match between the
summary statistics computed from the simulated data and the summary
statistics computed from the observed data.

The parameter values accepted in the rejection step are weighted by a smooth
function (kernel) of the distance between the simulated and observed summary
statistics and corrected according to a linear transformation. This function
calls the function \code{\link[stats:lm]{stats::lm()}} to accomplish this.
}
\examples{
# load the matrix with parameter values
data(params)
# load the matrix with simulated parameter values
data(sumstats)

# select a random simulation to act as target just to test the function
target <- sumstats[10 ,]

# parameter estimation using rejection sampling
rej <- rejABC(target = target, params = params, sumstats = sumstats[-10, ],
tol = 0.01, regression = TRUE)

# parameter estimation using local linear regression
# note that you should select a parameter from the unadjusted matrix
regABC(rej = rej, parameter = rej$unadjusted[, 1])

}
