% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbplyr.R
\name{dplyr-db-methods}
\alias{dplyr-db-methods}
\alias{copy_to.Pool}
\alias{tbl.Pool}
\alias{db_analyze.Pool}
\alias{db_begin.Pool}
\alias{db_commit.Pool}
\alias{db_create_index.Pool}
\alias{db_create_indexes.Pool}
\alias{db_create_table.Pool}
\alias{db_data_type.Pool}
\alias{db_desc.Pool}
\alias{db_drop_table.Pool}
\alias{db_explain.Pool}
\alias{db_has_table.Pool}
\alias{db_insert_into.Pool}
\alias{db_list_tables.Pool}
\alias{db_query_fields.Pool}
\alias{db_query_rows.Pool}
\alias{db_rollback.Pool}
\alias{db_save_query.Pool}
\alias{db_write_table.Pool}
\alias{sql_escape_ident.Pool}
\alias{sql_escape_string.Pool}
\alias{sql_join.Pool}
\alias{sql_select.Pool}
\alias{sql_semi_join.Pool}
\alias{sql_subquery.Pool}
\alias{sql_translate_env.Pool}
\alias{db_collect.Pool}
\alias{db_compute.Pool}
\alias{db_copy_to.Pool}
\alias{db_sql_render.Pool}
\alias{sql_escape_logical.Pool}
\title{DBIConnection methods from dplyr and dbplyr}
\usage{
\method{copy_to}{Pool}(dest, df, name = deparse(substitute(df)),
  overwrite = FALSE, temporary = TRUE, ...)

\method{tbl}{Pool}(src, from, ...)

\method{db_analyze}{Pool}(con, table, ...)

\method{db_begin}{Pool}(con, ...)

\method{db_commit}{Pool}(con, ...)

\method{db_create_index}{Pool}(con, table, columns, name = NULL,
  unique = FALSE, ...)

\method{db_create_indexes}{Pool}(con, table, indexes = NULL, unique = FALSE,
  ...)

\method{db_create_table}{Pool}(con, table, types, temporary = FALSE, ...)

\method{db_data_type}{Pool}(con, fields)

\method{db_desc}{Pool}(x)

\method{db_drop_table}{Pool}(con, table, force = FALSE, ...)

\method{db_explain}{Pool}(con, sql, ...)

\method{db_has_table}{Pool}(con, table)

\method{db_insert_into}{Pool}(con, table, values, ...)

\method{db_list_tables}{Pool}(con)

\method{db_query_fields}{Pool}(con, sql, ...)

\method{db_query_rows}{Pool}(con, sql, ...)

\method{db_rollback}{Pool}(con, ...)

\method{db_save_query}{Pool}(con, sql, name, temporary = TRUE, ...)

\method{db_write_table}{Pool}(con, table, types, values, temporary = FALSE,
  ...)

\method{sql_escape_ident}{Pool}(con, x)

\method{sql_escape_string}{Pool}(con, x)

\method{sql_join}{Pool}(con, x, y, vars, type = "inner", by = NULL, ...)

\method{sql_select}{Pool}(con, select, from, where = NULL, group_by = NULL,
  having = NULL, order_by = NULL, limit = NULL, distinct = FALSE, ...)

\method{sql_semi_join}{Pool}(con, x, y, anti = FALSE, by = NULL, ...)

\method{sql_subquery}{Pool}(con, from, name = random_table_name(), ...)

\method{sql_translate_env}{Pool}(con)

\method{db_collect}{Pool}(con, sql, n = -1, warn_incomplete = TRUE, ...)

\method{db_compute}{Pool}(con, table, sql, temporary = TRUE,
  unique_indexes = list(), indexes = list(), ...)

\method{db_copy_to}{Pool}(con, table, values, overwrite = FALSE,
  types = NULL, temporary = TRUE, unique_indexes = NULL, indexes = NULL,
  analyze = TRUE, ...)

\method{db_sql_render}{Pool}(con, sql, ...)

\method{sql_escape_logical}{Pool}(con, x)
}
\arguments{
\item{dest, df, name, overwrite, temporary, ..., src, from, con, table, columns, unique, indexes, types, fields, x, force, sql, values, y, vars, type, by, select, where, group_by, having, order_by, limit, distinct, anti, n, warn_incomplete, unique_indexes, analyze}{See original documentation.}
}
\description{
Pool object wrappers around DBIConnection methods, whose generics are
defined either in \code{dplyr} or in \code{dbplyr}.
For the original documentation, see
\href{http://dplyr.tidyverse.org/reference/index.html}{dplyr's reference page}
and \href{http://dbplyr.tidyverse.org/reference/index.html}{dbplyr's reference page}.
}
\examples{
library(dplyr)

pool <- dbPool(RSQLite::SQLite(), dbname = ":memory:")

# describe the type of the pool/its connections
db_desc(pool)

# use dplyr syntax to copy a table into the database
copy_to(pool, mtcars, "mtcars", temporary = FALSE)

# list the current tables in the database
db_list_tables(pool)

# extract a table from the database
mtcars_db <- tbl(pool, "mtcars")

# select only 3 columns
mtcars_db_thin <- select(mtcars_db, mpg, cyl, disp)

# get the names of the columns in the databases's table
db_query_fields(pool, "mtcars")

# get the number of rows in the databases's table
db_query_rows(pool, "mtcars")

# drop the "mtcars" table from the database
db_drop_table(pool, "mtcars")

# list the current tables in the database
db_list_tables(pool)

poolClose(pool)
}
