\name{dpoistweedie}
\alias{dpoistweedie}
\alias{densitept1}
\alias{densitept2}
\alias{dpt1}
\alias{dpt1Log}
\alias{dpt2}
\alias{dpt2Log}
\alias{dptp}
\alias{dptpLog}
\alias{gam1.1}
\alias{gam1.2}
\alias{imfx0}
\alias{moyennePT}
\alias{omega}
\alias{testOmegaPT}


\title{	The individual probabilities of Y when Y follows a Poisson-Tweedie Distributions }

\description{  Let X be a non-negative random variable following \eqn{\mathcal{T}_{P}(\theta , \lambda)}{T}. If a discrete random
variable Y is such that the conditional distribution of Y given X is Poisson with mean
X, then the EDM generated by the distribution of Y is of the Poisson-Tweedie class. For \eqn{p>=1}{p} individual probabilities of \eqn{Y\sim\mathcal{P\mathcal{T}_{P}(\theta ,\lambda )}}{Y} when Y follows a Poisson-Tweedie Distributions are: 
\eqn{ Pr(Y=y)=\int_{0}^{\infty}\frac{e^{-x}x^{y}}{y!}\mathcal{T}_{P}(\theta , \lambda)d(x), y=0,1, 
}{funtion Probabilitie}.\cr
For p = 1, it is a Neyman type A distribution; for \eqn{1<p<2}{p compris entre 1 et 2} , then Poisson-compound Poisson  distribution is obtained; 
for p = 2,the Poisson-Tweedie model \eqn{PT_{2}\left(\mu,\lambda\right) }{PTM} correspond  to the negative binomiale law \eqn{BN\left(
 \lambda,\frac{1}{1+\mu}\right)}{lois BN}; and, for p = 3, it is the Sichel or Poisson-inverse
Gaussian distribution (e.g. Willmot, 1987). Also, when \eqn{p\longrightarrow\infty}{p tends vers l'infini},
\eqn{\lambda=\frac{\mu\times\left(  1-\theta_{0}\right)  }{1+\mu}}{lamda}  and the
 \eqn{\lambda=\mu\simeq-\theta_{0}}{mu egal to lambda and theta0} , the Poisson-Tweedie model
     \eqn{PT_{p}\left(  \mu,\lambda\right)}{PTM} correspond  to the poisson law
     \eqn{ P_{y}\left(  \lambda^{2}\right)}{Law of Poisson}. \cr
}

 
	 
\usage{dpoistweedie(y, p, mu, lambda, theta0, log)
       densitept1(p, n, mu, lambda, theta0)
       densitept2(p, n, mu, lambda, theta0)
       dpt1(p, n, mu, lambda, theta0)
       dpt1Log(p, n, mu, lambda, theta0)
       dpt2(p, n, mu, lambda, theta0)
       dpt2Log(p, n, mu, lambda, theta0)
       dptp(p, n, mu, lambda, theta0)
       dptpLog(p, n, mu, lambda, theta0)
       gam1.1(y, lambda)
       gam1.2(y, lambda)
       imfx0(x0,p,mu,theta0)
       moyennePT(p,omega,theta0)
       omega(p,mu,theta0)
       testOmegaPT(p,n)

}

\arguments{
\item{y}{vector of (non-negative integer) quantiles \eqn{Y=(y1,y2,...,yn) \ where \ \ yi i=1,2,...,n}{y} are the integer.}
\item{p}{is a real index related to a precise model \eqn{p>=1}{p}. }
\item{n}{non-negative integer (length of y)}
\item{x0}{is a real index }
\item{mu}{the mean\eqn{\mu\in{R}^{+}}{mu}, . }
\item{omega}{is a real index.\eqn{\omega\in{R}}{omega}}
\item{lambda}{the dispersion parameter \eqn{\lambda\in{R},\lambda>0}{lamda}.}
\item{theta0}{the canonical parameter \eqn{\theta_{0}\in{R}^{-}}{theta0}.}
\item{log}{logical; if TRUE, probabilities y are given as log(y).}

}

\value{
density (\code{dpoistweedie}),for the given Poisson-Tweedie distribution with parameters 
}

\details{
    The Poisson-Tweedie distributions arethe EDMs with a variance of the form 
	\eqn{V_{p}^{\mathcal{PT}}\left(  \mu\right)  =\mu+\mu^{p}\exp\left\{  \left(2-p\right)  \Phi_{p}\left(  \mu\right)  \right\}  ,\mu>0}{formule de la variance PT}, 
	where \eqn{\Phi_{p}\left(  \mu\right) }{phi} a generally implicit, denotes the inverse of the increansing function 
	\eqn{\omega\longrightarrow\frac{d\left\{  \ln IE\left(  e^{wy}\right)  \right\}}{dw}}{fonction inverse de W}. omega(p,mu,theta0) is a function whose permit to determine the value of w.  
}


\author{Cactha David Pechel, Laure Pauline Fotso  and  Celestin C Kokonendji
Maintainer: Cactha David Pechel ( <davidpechel@yahoo.fr>)}


\references{
Dunn, Peter K and Smyth, Gordon K (To appear).
Series evaluation of Tweedie exponential dispersion model densities
\emph{Statistics and Computing}.

Dunn, Peter K and Smyth, Gordon K (2001).
Tweedie family densities: methods of evaluation.
\emph{Proceedings of the 16th International Workshop on Statistical Modelling},
Odense, Denmark, 2--6 July

Hougaard, P., Lee, M-L.T. and Whitmore, G.A. (1997). Analysis of
overdispersed count data by mixtures of Poisson variables and Poisson processes,
\emph{Biometrics}
\bold{53}, 1225--1238

Jorgensen, B. (1987).
Exponential dispersion models.
\emph{Journal of the Royal Statistical Society}, B,
\bold{49}, 127--162.

Kokonendji, C.C., Demeetrio, C.G.B. and Dossou-Gbete, S. (2004). Some
discrete exponential dispersion models: Poisson-Tweedie and Hinde-Demetrio
classes. SORT: Statistics and Operations Research Transactions 
\bold{28} (2), 201--214. 

}

\seealso{\code{\link{ppoistweedie}}}

\examples{   
## dpoistweedie(y, power, mu,lambda,theta0,log = FALSE)
## Plot dpois() and dpoistweedie() with  log=FALSE
layout(matrix(1 :1, 1, 1))
layout.show(2) 
power <- exp(10) 
mu <-10
lambda <- 10
theta0<--10
lambda1<-100
y <- 0:200
## plot  dpoistweedie function with log = FALSE
d1<-dpoistweedie(y,power,mu,lambda,theta0,log = FALSE)
d2<-dpois(y,lambda1,log=FALSE)
erreure<-d1-d2
plot (y,d1,col='blue', type='h',xlab="y 
   avec  y=0:200,  power=exp(30),mu=10, lambda=10,
   theta0=-10,  lambda1=100", ylab="densite P(100)",
   main = "dpoistweedie(*,col='blue' log=FALSE)
   et dpois(*,col='red' log=FALSE)")
lines(y,d2,type ="p",col='red',lwd=2)
sum(abs(erreure))



## Plot dnbinom() and dpoistweedie()
layout(matrix(1 :1, 1, 1))
layout.show(2) 
power<-2 
mu<-10
lambda <- 1
theta0<-0
prob<-1-(mu/(1+mu))
y <- seq(0,50, by =3)
## plot a dpoistweedie function with log=FALSE
d1<-dpoistweedie(y,power,mu,lambda,theta0,log=FALSE)
d2<-dnbinom(y,lambda,prob, log=FALSE)
erreure<-d1-d2
plot (y,d1,col='blue', type='h',xlab="y 
   avec  y=seq(0,50,by=3),  power=2,mu=10, 
   lambda=1, thetao=0", ylab="densite NB(1,1/11)"
   ,main = "dnpoistweedie(*,col='blue' log=FALSE)
   et dnbinom(*,col='red' log=FALSE)")
lines(y,d2,type ="p",col='red',lwd=2)
abs(erreure)
 } 
\keyword{models}
















