% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.r
\name{utils_clean_address}
\alias{utils_clean_address}
\title{Clean directory address entries}
\usage{
utils_clean_address(directory, type = c("body", "number", "ends"))
}
\arguments{
\item{directory}{A directory dataframe.}

\item{type}{A character string: "body", "number" or "ends". Specifies the type
of address cleaning to be performed. For "body", "number" and "ends"
\code{\link{clean_address_body}}, \code{\link{clean_address_number}} and
\code{\link{clean_address_ends}} are called respectively}
}
\value{
A dataframe.
}
\description{
Clean address entries in the provided directory dataframe.
}
\examples{
\dontrun{
  directory <- data.frame(
    page = c("71", "71"),
    surname = c("ABOT", "ABRCROMBIE"), forename = c("Wm.", "Alex"),
    occupation = c("Wine and spirit merchant", "Baker"),
    address.number = c(" -; 1820", ",,12"),
    address.body = c(
      "London st. ; house, Mary hill.*",
      "&;Dixon st.; residence, Craigrownie, Cove.$"
    ),
    stringsAsFactors = FALSE
  )
  utils_clean_address(directory, "body")
  utils_clean_address(directory, "number")
}
}
