% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general.r
\name{general_split_trade_addresses}
\alias{general_split_trade_addresses}
\title{Mutate operation(s) in Scottish post office general directory data.frame
column(s)}
\usage{
general_split_trade_addresses(
  directory,
  regex_split,
  ignore_case_split,
  regex_filter,
  ignore_case_filter,
  regex_match,
  ignore_case_match
)
}
\arguments{
\item{directory}{A Scottish post office general directory in the form
of a data.frame or other object that inherits from the data.frame class
such as a \code{\link[tibble]{tibble}}. Columns must at least include
\code{addresses.trade}.}

\item{regex_split}{Regex to use to split addresses.}

\item{ignore_case_split}{Boolean specifying whether case should be ignored
(\code{TRUE}) or not (\code{FALSE}) for \code{regex_split} above.}

\item{regex_filter}{Regex to use to search for address entries with post-split
undesired leftovers.}

\item{ignore_case_filter}{Boolean specifying whether case should be ignored
(\code{TRUE}) or not (\code{FALSE}) for \code{regex_filter} above.}

\item{regex_match}{Regex to use to clear address entries from post-split
undesired leftovers.}

\item{ignore_case_match}{Boolean specifying whether case should be ignored
(\code{TRUE}) or not (\code{FALSE}) for \code{regex_match} above.}
}
\value{
A data.frame of the same class as the one provided in \code{directory};
columns include at least \code{address.trade}. Multiple trade addresses are
separated for entries for which more than one are provided. Each trade
address identified lives on an individual row with information in the other
columns duplicated.
}
\description{
Attempts to separate multiple trade addresses in the Scottish
post office general directory data.frame provided for entries for which
more than one are provided.
}
