% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trelliPlots_seqData.R
\name{trelli_rnaseq_boxplot}
\alias{trelli_rnaseq_boxplot}
\title{Boxplot trelliscope building function for RNA-seq data}
\usage{
trelli_rnaseq_boxplot(
  trelliData,
  cognostics = c("count", "mean lcpm"),
  ggplot_params = NULL,
  interactive = FALSE,
  include_points = TRUE,
  path = .getDownloadsFolder(),
  name = "Trelliscope",
  test_mode = FALSE,
  test_example = 1,
  single_plot = FALSE,
  ...
)
}
\arguments{
\item{trelliData}{A trelliscope data object made by as.trelliData or
as.trelliData.edata, and grouped by trelli_panel_by. Must be built using 
seqData. Required.}

\item{cognostics}{A vector of cognostic options for each plot. Valid entries
are "count", "mean lcpm", "median lcpm", and "cv lcpm". 
If data are paneled by a biomolecule, the count will be "sample count".
If data are paneled by a sample or a biomolecule class, the count will be "biomolecule count". 
If statRes data is included, "p-value" and "fold change" data per comparisons
may be added. If grouping information is included, only "sample count" and 
"mean lcpm" will be calculated, along with "p-value" and "fold change"
if specified. "p-value" will not be included if paneling a trelliscope
display by a biomolecule class. Default is "sample count" and "mean lcpm".}

\item{ggplot_params}{An optional vector of strings of ggplot parameters to
the backend ggplot function. For example, c("ylab('')", "ylim(c(2,20))").
Default is NULL.}

\item{interactive}{A logical argument indicating whether the plots should be
interactive or not. Interactive plots are ggplots piped to ggplotly (for
now). Default is FALSE.}

\item{include_points}{Add points as a geom_jitter. Default is TRUE.}

\item{path}{The base directory of the trelliscope application. Default is
Downloads.}

\item{name}{The name of the display. Default is Trelliscope.}

\item{test_mode}{A logical to return a smaller trelliscope to confirm plot
and design. Default is FALSE.}

\item{test_example}{A vector of plot indices to return for test_mode. Default
is 1.}

\item{single_plot}{A TRUE/FALSE to indicate whether 1 plot (not a
trelliscope) should be returned. Default is FALSE.}

\item{...}{Additional arguments to be passed on to the trelli builder}
}
\value{
No return value, builds a trelliscope display of boxplots that is stored in `path`
}
\description{
Specify a boxplot design and cognostics for the RNA-Seq
  boxplot trelliscope. Each boxplot will have its own groups as specified by
  the first main effect in group_designation. Use "trelli_abundance_boxplot"
  for MS/NMR-based omics.
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{
library(pmartRdata)

trelliData_seq1 <- as.trelliData.edata(e_data = rnaseq_edata,
                                      edata_cname = "Transcript",
                                      omics_type = "seqData")
omicsData_seq <- group_designation(omicsData = rnaseq_object, main_effects = c("Virus"))

# Filter low transcript counts
omicsData_seq <- applyFilt(filter_object = total_count_filter(omicsData = omicsData_seq), 
 omicsData = omicsData_seq, min_count = 15)

# Select a normalization and statistics method (options are 'edgeR', 'DESeq2', and 'voom').
# See ?difexp_seq for more details
statRes_seq <- diffexp_seq(omicsData = omicsData_seq, method = "voom")

# Generate the trelliData object
trelliData_seq2 <- as.trelliData(omicsData = omicsData_seq)
trelliData_seq3 <- as.trelliData(statRes = statRes_seq)
trelliData_seq4 <- as.trelliData(omicsData = omicsData_seq, statRes = statRes_seq)

## Generate trelliData objects using the as.trelliData.edata example code.

# Build the RNA-seq boxplot with an edata file where each panel is a biomolecule. 
trelli_panel_by(trelliData = trelliData_seq1, panel = "Transcript") \%>\% 
   trelli_rnaseq_boxplot(test_mode = TRUE, test_example = 1:10, path = tempdir())
   
# Build the RNA-seq boxplot where each panel is a sample.
# Include all applicable cognostics. Remove points. 
trelli_panel_by(trelliData = trelliData_seq1, panel = "Sample") \%>\% 
   trelli_rnaseq_boxplot(test_mode = TRUE, test_example = 1:10, 
                            include_points = FALSE,
                            cognostics = c("count", 
                                           "mean lcpm", 
                                           "median lcpm", 
                                           "cv lcpm"),
                            path = tempdir()
                           )

# Build the RNA-seq boxplot with an omicsData object.
# Let the panels be biomolecules. Here, grouping information is included.
trelli_panel_by(trelliData = trelliData_seq2, panel = "Transcript") \%>\% 
   trelli_rnaseq_boxplot(test_mode = TRUE, test_example = 1:10, path = tempdir())
   
# Build the RNA-seq boxplot with an omicsData object. The panel is a biomolecule class,
# which is proteins in this case.
trelli_panel_by(trelliData = trelliData_seq2, panel = "Gene") \%>\% 
   trelli_rnaseq_boxplot(test_mode = TRUE, test_example = 1:10, path = tempdir())
    
# Build the RNA-seq boxplot with an omicsData and statRes object.
# Panel by a biomolecule, and add statistics data to the cognostics
trelli_panel_by(trelliData = trelliData_seq4, panel = "Transcript") \%>\%
   trelli_rnaseq_boxplot(test_mode = TRUE, test_example = 1:10,
     cognostics = c("mean lcpm", "p-value", "fold change"), path = tempdir())
 
# Other options include modifying the ggplot  
trelli_panel_by(trelliData = trelliData_seq1, panel = "Transcript") \%>\%
   trelli_rnaseq_boxplot(test_mode = TRUE, test_example = 1:10,
     ggplot_params = c("ylab('')", "xlab('')"), path = tempdir())

# Or making the plot interactive 
trelli_panel_by(trelliData = trelliData_seq4, panel = "Gene") \%>\%
    trelli_rnaseq_boxplot(interactive = TRUE, test_mode = TRUE, 
     test_example = 1:10, path = tempdir())

\dontshow{closeAllConnections()}
}
\dontshow{\}) # examplesIf}
}
\author{
David Degnan, Lisa Bramer
}
