% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plmm_prep.R
\name{plmm_prep}
\alias{plmm_prep}
\title{PLMM prep: a function to run checks, SVD, and rotation prior to fitting a PLMM model
This is an internal function for \code{cv_plmm}}
\usage{
plmm_prep(
  std_X,
  std_X_n,
  std_X_p,
  n,
  p,
  centered_y,
  K = NULL,
  diag_K = NULL,
  eta_star = NULL,
  fbm_flag,
  trace = NULL,
  ...
)
}
\arguments{
\item{std_X}{Column standardized design matrix. May include clinical covariates and other non-SNP data.}

\item{std_X_n}{The number of observations in std_X (integer)}

\item{std_X_p}{The number of features in std_X (integer)}

\item{n}{The number of instances in the \emph{original} design matrix X. This should not be altered by standardization.}

\item{p}{The number of features in the \emph{original} design matrix X, including constant features}

\item{centered_y}{Continuous outcome vector, centered.}

\item{K}{Similarity matrix used to rotate the data. This should either be a known matrix that reflects the covariance of y, or an estimate (Default is \eqn{\frac{1}{p}(XX^T)}, where X is standardized). This can also be a list, with components d and u (as returned by choose_k)}

\item{diag_K}{Logical: should K be a diagonal matrix? This would reflect observations that are unrelated, or that can be treated as unrelated. Passed from \code{plmm()}.}

\item{eta_star}{Optional argument to input a specific eta term rather than estimate it from the data. If K is a known covariance matrix that is full rank, this should be 1.}

\item{fbm_flag}{Logical: is std_X an FBM type object? This is set internally by \code{plmm()}.}

\item{trace}{If set to TRUE, inform the user of progress by announcing the beginning of each step of the modeling process. Default is FALSE.}

\item{...}{Not used yet}
}
\value{
List with these components:
\itemize{
\item centered_y: The vector of centered outcomes
\item std_X: standardized design matrix
\item K: a list with 2 elements. (1) s: vector with the eigenvalues of K,
and (2) U: the eigenvectors of K (same as left singular values of X).
\item eta: the numeric value of the estimated eta parameter
\item trace: logical.
}
}
\description{
PLMM prep: a function to run checks, SVD, and rotation prior to fitting a PLMM model
This is an internal function for \code{cv_plmm}
}
\keyword{internal}
