% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/git-protocol.R
\name{git_fetch}
\alias{git_fetch}
\title{Get a packfile for an object from a remote git repository}
\usage{
git_fetch(url, sha, blobs = FALSE)
}
\arguments{
\item{url}{Repository URL, e.g. \verb{https://github.com/r-lib/pak.git}.
It might include authentication information, e.g. a GitHub token.}

\item{sha}{SHA of the object to get.}

\item{blobs}{Whether we want to download all blobs as well or not.
We are still always requesting a shallow (depth = 1) clone.}
}
\value{
A list of git objects. Each element has entries:
\itemize{
\item \code{type}: \code{commit}, \code{tree}, \code{blob} or \code{tag}.
\item \code{object}: the object itself. It is a
\itemize{
\item character scalar for commits,
\item a data frame for trees, with columns: \code{type}, \code{mode}, \code{path}, \code{hash},
\item a raw vector for blobs,
\item a raw vector for tags. (We could probably do better here.)
}
}
}
\description{
Get a packfile for an object from a remote git repository
}
\details{
It uses \verb{filter blob:none}, so extra blobs are not downloaded, only
trees.
}
\section{Examples}{


\if{html}{\out{<div class="sourceCode r">}}\preformatted{ft <- git_fetch(
  "https://github.com/r-lib/filelock.git",
  "9fdba75a62facaa3e818902f58891166e45eabe9"
)
ft
#> [[1]]
#> [[1]]$type
#> [1] "commit"
#> 
#> [[1]]$object
#> [1] "tree f92fab4f8594bd2e6c10f6f3e5dd44e556d7bb7e\\nparent 7c5389719fa50e1827195771ac07c01d44ababa1\\nauthor Gábor Csárdi <csardi.gabor@gmail.com> 1538733728 +0100\\ncommitter Gábor Csárdi <csardi.gabor@gmail.com> 1538733728 +0100\\n\\nFix spelling\\n"
#> 
#> [[1]]$size
#> [1] 239
#> 
#> [[1]]$packed_size
#> [1] 162
#> 
#> [[1]]$raw
#>   [1] 74 72 65 65 20 66 39 32 66 61 62 34 66 38 35 39 34 62 64 32 65 36 63 31 30
#>  [26] 66 36 66 33 65 35 64 64 34 34 65 35 35 36 64 37 62 62 37 65 0a 70 61 72 65
#>  [51] 6e 74 20 37 63 35 33 38 39 37 31 39 66 61 35 30 65 31 38 32 37 31 39 35 37
#>  [76] 37 31 61 63 30 37 63 30 31 64 34 34 61 62 61 62 61 31 0a 61 75 74 68 6f 72
#> [101] 20 47 c3 a1 62 6f 72 20 43 73 c3 a1 72 64 69 20 3c 63 73 61 72 64 69 2e 67
#> [126] 61 62 6f 72 40 67 6d 61 69 6c 2e 63 6f 6d 3e 20 31 35 33 38 37 33 33 37 32
#> [151] 38 20 2b 30 31 30 30 0a 63 6f 6d 6d 69 74 74 65 72 20 47 c3 a1 62 6f 72 20
#> [176] 43 73 c3 a1 72 64 69 20 3c 63 73 61 72 64 69 2e 67 61 62 6f 72 40 67 6d 61
#> [201] 69 6c 2e 63 6f 6d 3e 20 31 35 33 38 37 33 33 37 32 38 20 2b 30 31 30 30 0a
#> [226] 0a 46 69 78 20 73 70 65 6c 6c 69 6e 67 0a
#> 
#> [[1]]$hash
#> [1] "9fdba75a62facaa3e818902f58891166e45eabe9"
#> 
#> 
#> [[2]]
#> [[2]]$type
#> [1] "tree"
#> 
#> [[2]]$object
#>    type   mode          path                                     hash
#> 1  blob 100644 .Rbuildignore 45181a7157bdd799f225dd8d5b27a224b6a9a2d2
#> 2  blob 100644    .gitignore 9cb99ac4c7fa31d5450f62f8da3487c8a4162e96
#> 3  blob 100644   .travis.yml 85a387228f1b4a0c70d359122f487979ed5eb4a9
#> 4  blob 100644   DESCRIPTION 6013cb378eb62302ec176334b0ab4a2993da1e5e
#> 5  blob 100644       LICENSE 1fd2b3ad1dc5f2f946eae143ee3b45da36180bdd
#> 6  blob 100644      Makefile dd7836b14f4a04d20a3139c05c76b01a258ffcf3
#> 7  blob 100644     NAMESPACE 906fa2f11a0ba9b43a3e43c9b0cf840fb13dde1b
#> 8  blob 100644       NEWS.md f84230bc2ae5f2768677ee72d1085e599263c202
#> 9  tree  40000             R 9c8a4edfaff37a8ee20afe3ff0ec7e18b29b6d3e
#> 10 blob 100644    README.Rmd b270933f20b5e16c8a3b3fb3e9bf6a8cfd464ec0
#> 11 blob 100644     README.md d037742ef37ecb903a55d7484cfa30f725085162
#> 12 blob 100644  appveyor.yml 6168ec3805795bd92657ee8bc0208931f4b807d1
#> 13 tree  40000          inst 22c1c69cb093311abb2983012e26bbc20e9fe753
#> 14 tree  40000           man 674f6be38465d83b3f8b44d97bab040ff84b4794
#> 15 tree  40000           src abeb2f2376694746a00797a2c20df24daea66ba3
#> 16 tree  40000         tests 00ad597f0ec5aa7aab56afce1088d67685ef7395
#> 
#> [[2]]$size
#> [1] 566
#> 
#> [[2]]$packed_size
#> [1] 505
#> 
#> [[2]]$raw
#>   [1] 31 30 30 36 34 34 20 2e 52 62 75 69 6c 64 69 67 6e 6f 72 65 00 45 18 1a 71
#>  [26] 57 bd d7 99 f2 25 dd 8d 5b 27 a2 24 b6 a9 a2 d2 31 30 30 36 34 34 20 2e 67
#>  [51] 69 74 69 67 6e 6f 72 65 00 9c b9 9a c4 c7 fa 31 d5 45 0f 62 f8 da 34 87 c8
#>  [76] a4 16 2e 96 31 30 30 36 34 34 20 2e 74 72 61 76 69 73 2e 79 6d 6c 00 85 a3
#> [101] 87 22 8f 1b 4a 0c 70 d3 59 12 2f 48 79 79 ed 5e b4 a9 31 30 30 36 34 34 20
#> [126] 44 45 53 43 52 49 50 54 49 4f 4e 00 60 13 cb 37 8e b6 23 02 ec 17 63 34 b0
#> [151] ab 4a 29 93 da 1e 5e 31 30 30 36 34 34 20 4c 49 43 45 4e 53 45 00 1f d2 b3
#> [176] ad 1d c5 f2 f9 46 ea e1 43 ee 3b 45 da 36 18 0b dd 31 30 30 36 34 34 20 4d
#> [201] 61 6b 65 66 69 6c 65 00 dd 78 36 b1 4f 4a 04 d2 0a 31 39 c0 5c 76 b0 1a 25
#> [226] 8f fc f3 31 30 30 36 34 34 20 4e 41 4d 45 53 50 41 43 45 00 90 6f a2 f1 1a
#> [251] 0b a9 b4 3a 3e 43 c9 b0 cf 84 0f b1 3d de 1b 31 30 30 36 34 34 20 4e 45 57
#> [276] 53 2e 6d 64 00 f8 42 30 bc 2a e5 f2 76 86 77 ee 72 d1 08 5e 59 92 63 c2 02
#> [301] 34 30 30 30 30 20 52 00 9c 8a 4e df af f3 7a 8e e2 0a fe 3f f0 ec 7e 18 b2
#> [326] 9b 6d 3e 31 30 30 36 34 34 20 52 45 41 44 4d 45 2e 52 6d 64 00 b2 70 93 3f
#> [351] 20 b5 e1 6c 8a 3b 3f b3 e9 bf 6a 8c fd 46 4e c0 31 30 30 36 34 34 20 52 45
#> [376] 41 44 4d 45 2e 6d 64 00 d0 37 74 2e f3 7e cb 90 3a 55 d7 48 4c fa 30 f7 25
#> [401] 08 51 62 31 30 30 36 34 34 20 61 70 70 76 65 79 6f 72 2e 79 6d 6c 00 61 68
#> [426] ec 38 05 79 5b d9 26 57 ee 8b c0 20 89 31 f4 b8 07 d1 34 30 30 30 30 20 69
#> [451] 6e 73 74 00 22 c1 c6 9c b0 93 31 1a bb 29 83 01 2e 26 bb c2 0e 9f e7 53 34
#> [476] 30 30 30 30 20 6d 61 6e 00 67 4f 6b e3 84 65 d8 3b 3f 8b 44 d9 7b ab 04 0f
#> [501] f8 4b 47 94 34 30 30 30 30 20 73 72 63 00 ab eb 2f 23 76 69 47 46 a0 07 97
#> [526] a2 c2 0d f2 4d ae a6 6b a3 34 30 30 30 30 20 74 65 73 74 73 00 00 ad 59 7f
#> [551] 0e c5 aa 7a ab 56 af ce 10 88 d6 76 85 ef 73 95
#> 
#> [[2]]$hash
#> [1] "f92fab4f8594bd2e6c10f6f3e5dd44e556d7bb7e"
#> 
#> 
#> [[3]]
#> [[3]]$type
#> [1] "tree"
#> 
#> [[3]]$object
#>   type   mode         path                                     hash
#> 1 blob 100644 assertions.R c6931259482e745c75d48325f23dc2fcd06f56ff
#> 2 blob 100644    package.R 88554b8a205c4005d6f7025c21463a8182f458ab
#> 
#> [[3]]$size
#> [1] 77
#> 
#> [[3]]$packed_size
#> [1] 81
#> 
#> [[3]]$raw
#>  [1] 31 30 30 36 34 34 20 61 73 73 65 72 74 69 6f 6e 73 2e 52 00 c6 93 12 59 48
#> [26] 2e 74 5c 75 d4 83 25 f2 3d c2 fc d0 6f 56 ff 31 30 30 36 34 34 20 70 61 63
#> [51] 6b 61 67 65 2e 52 00 88 55 4b 8a 20 5c 40 05 d6 f7 02 5c 21 46 3a 81 82 f4
#> [76] 58 ab
#> 
#> [[3]]$hash
#> [1] "9c8a4edfaff37a8ee20afe3ff0ec7e18b29b6d3e"
#> 
#> 
#> [[4]]
#> [[4]]$type
#> [1] "tree"
#> 
#> [[4]]$object
#>   type   mode     path                                     hash
#> 1 blob 100644 WORDLIST 538ab5ce786efef03728f2a5b4592a6ae99c35e5
#> 
#> [[4]]$size
#> [1] 36
#> 
#> [[4]]$packed_size
#> [1] 45
#> 
#> [[4]]$raw
#>  [1] 31 30 30 36 34 34 20 57 4f 52 44 4c 49 53 54 00 53 8a b5 ce 78 6e fe f0 37
#> [26] 28 f2 a5 b4 59 2a 6a e9 9c 35 e5
#> 
#> [[4]]$hash
#> [1] "22c1c69cb093311abb2983012e26bbc20e9fe753"
#> 
#> 
#> [[5]]
#> [[5]]$type
#> [1] "tree"
#> 
#> [[5]]$object
#>   type   mode    path                                     hash
#> 1 blob 100644 lock.Rd c3899949a3573e8ad670610ba389812dd3c9bc90
#> 
#> [[5]]$size
#> [1] 35
#> 
#> [[5]]$packed_size
#> [1] 44
#> 
#> [[5]]$raw
#>  [1] 31 30 30 36 34 34 20 6c 6f 63 6b 2e 52 64 00 c3 89 99 49 a3 57 3e 8a d6 70
#> [26] 61 0b a3 89 81 2d d3 c9 bc 90
#> 
#> [[5]]$hash
#> [1] "674f6be38465d83b3f8b44d97bab040ff84b4794"
#> 
#> 
#> [[6]]
#> [[6]]$type
#> [1] "tree"
#> 
#> [[6]]$object
#>   type   mode               path                                     hash
#> 1 blob 100644           Makevars 945ce829c1bc15a9924342767db832184bea2fe7
#> 2 blob 100644       Makevars.win 1f37ea58dd205928e3f499c6e1db91460e220f9c
#> 3 blob 100644    filelock-unix.c 0ecfc663a398a9136ef1e5173f0565a8f733544c
#> 4 blob 100644 filelock-windows.c f1e4aae78e81a193ea6a87b7f465bce0eb98d761
#> 5 blob 100644         filelock.h 4aec0dd604f36863d81e693a1424bcf8388397ba
#> 6 blob 100644             init.c 2fd89e49f397d31cfd33e895f03d598c7eeca119
#> 7 blob 100644         locklist.c 810c2ea35d59f0336b66ab4f5d31a301e4049b85
#> 8 blob 100644             utf8.c 47849fb8467b37da6620ef1a714894142a851139
#> 
#> [[6]]$size
#> [1] 309
#> 
#> [[6]]$packed_size
#> [1] 259
#> 
#> [[6]]$raw
#>   [1] 31 30 30 36 34 34 20 4d 61 6b 65 76 61 72 73 00 94 5c e8 29 c1 bc 15 a9 92
#>  [26] 43 42 76 7d b8 32 18 4b ea 2f e7 31 30 30 36 34 34 20 4d 61 6b 65 76 61 72
#>  [51] 73 2e 77 69 6e 00 1f 37 ea 58 dd 20 59 28 e3 f4 99 c6 e1 db 91 46 0e 22 0f
#>  [76] 9c 31 30 30 36 34 34 20 66 69 6c 65 6c 6f 63 6b 2d 75 6e 69 78 2e 63 00 0e
#> [101] cf c6 63 a3 98 a9 13 6e f1 e5 17 3f 05 65 a8 f7 33 54 4c 31 30 30 36 34 34
#> [126] 20 66 69 6c 65 6c 6f 63 6b 2d 77 69 6e 64 6f 77 73 2e 63 00 f1 e4 aa e7 8e
#> [151] 81 a1 93 ea 6a 87 b7 f4 65 bc e0 eb 98 d7 61 31 30 30 36 34 34 20 66 69 6c
#> [176] 65 6c 6f 63 6b 2e 68 00 4a ec 0d d6 04 f3 68 63 d8 1e 69 3a 14 24 bc f8 38
#> [201] 83 97 ba 31 30 30 36 34 34 20 69 6e 69 74 2e 63 00 2f d8 9e 49 f3 97 d3 1c
#> [226] fd 33 e8 95 f0 3d 59 8c 7e ec a1 19 31 30 30 36 34 34 20 6c 6f 63 6b 6c 69
#> [251] 73 74 2e 63 00 81 0c 2e a3 5d 59 f0 33 6b 66 ab 4f 5d 31 a3 01 e4 04 9b 85
#> [276] 31 30 30 36 34 34 20 75 74 66 38 2e 63 00 47 84 9f b8 46 7b 37 da 66 20 ef
#> [301] 1a 71 48 94 14 2a 85 11 39
#> 
#> [[6]]$hash
#> [1] "abeb2f2376694746a00797a2c20df24daea66ba3"
#> 
#> 
#> [[7]]
#> [[7]]$type
#> [1] "tree"
#> 
#> [[7]]$object
#>   type   mode       path                                     hash
#> 1 blob 100644 testthat.R ba0c4a16402c81fcf9e23f5435e2f3dc00726805
#> 2 tree  40000   testthat 70486852bb6531d18f3ec76170ded201e320bbd8
#> 
#> [[7]]$size
#> [1] 73
#> 
#> [[7]]$packed_size
#> [1] 74
#> 
#> [[7]]$raw
#>  [1] 31 30 30 36 34 34 20 74 65 73 74 74 68 61 74 2e 52 00 ba 0c 4a 16 40 2c 81
#> [26] fc f9 e2 3f 54 35 e2 f3 dc 00 72 68 05 34 30 30 30 30 20 74 65 73 74 74 68
#> [51] 61 74 00 70 48 68 52 bb 65 31 d1 8f 3e c7 61 70 de d2 01 e3 20 bb d8
#> 
#> [[7]]$hash
#> [1] "00ad597f0ec5aa7aab56afce1088d67685ef7395"
#> 
#> 
#> [[8]]
#> [[8]]$type
#> [1] "tree"
#> 
#> [[8]]$object
#>   type   mode   path                                     hash
#> 1 blob 100644 test.R c1ec36f67434b9e03524180ed3646121ec03e113
#> 
#> [[8]]$size
#> [1] 34
#> 
#> [[8]]$packed_size
#> [1] 43
#> 
#> [[8]]$raw
#>  [1] 31 30 30 36 34 34 20 74 65 73 74 2e 52 00 c1 ec 36 f6 74 34 b9 e0 35 24 18
#> [26] 0e d3 64 61 21 ec 03 e1 13
#> 
#> [[8]]$hash
#> [1] "70486852bb6531d18f3ec76170ded201e320bbd8"
}\if{html}{\out{</div>}}
}

\keyword{internal}
