% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\docType{data}
\name{config}
\alias{config}
\title{Package configuration (internals)}
\format{
\code{config} is a list of functions with a closure. You can use it two ways.

For \emph{one} set of configuration values in a package, include this in
\code{.onLoad()}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{conf <- config$new("prefix")
conf$add("myenrry", "string", "default-value")
...
conf$lock()
}\if{html}{\out{</div>}}

For _multiple _ sets of configuration values (e.g. one per object),
include a function like this in the package:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{current_config <- function() \{
  conf <- config$new("prefix")
  conf$add("myentry", "string", "default-value")
  ...
  conf$lock()
  conf
\}
}\if{html}{\out{</div>}}

and then call \code{current_config()} every time you need to create a
new set of configuration values.
}
\usage{
config
}
\description{
Internal machinery for pkgdepends configuration. See \code{\link[=current_config]{current_config()}}
for how this machinery can be used to define the configuration of a
package.

This is a standalone file that can be copied into another package without
changes.
}
\section{Terminology}{
\subsection{Config entry (or entry)}{

A single configurable entity. A config entry has a name. This name is
always standardized by replacing dashes with underscores.

A config entry has a type: a string, a flag, or some
user defined type. It can also have a default value. Examples:
\itemize{
\item The URL of an API, which can be a string.
\item Path to a directory to use for caching, either a string, or NULL
(\code{string_or_null} type).
\item Number of processor cores to use, a positive integer (\code{count} type).
}
}

\subsection{Configuration (or config)}{

A set of configuration entries. \code{config$new()} returns a configuration.
A configuration can be extended by adding new entries to it, until it
is locked.
}

\subsection{R option (or option)}{

An option set with \code{\link[base:options]{base::options()}} and queried with \code{\link[base:options]{base::getOption()}}.
}

\subsection{Configuration prefix}{

A prefix that is typically package specific, and it is used for all
config entries of a package, to avoid environment variable and option
name clashes between packages.
}

\subsection{Config entry type}{

It defines the allowed values of configuration entries, and also how
a string from an environment variable is translated to the value of
the entry. See the list of builtin types below. You can also define new
types.
}
}

\section{Built-in types}{
\subsection{\code{string}}{

String scalar, \code{NA} is not allowed.
}

\subsection{\code{count}}{

Non-negative integer, \code{NA} is not allowed.
}

\subsection{\code{flag}}{

Logical scalar, \code{NA} is not allowed. For environment variables the
\code{TRUE} values are: \code{yes}, \code{true}, \code{1} and \code{on}, and the \code{FALSE} values
are: \code{no}, \code{false}, \code{0}, \code{off}. (All are case insensitive.)
}

\subsection{\code{string_or_null}}{

String or \code{NULL}. \code{NA} is not allowed. In environment variables the
string \code{NULL} means an R \code{NULL} value.
}

\subsection{\code{character}}{

Character vector without \code{NA} values. In environment variables the
entries are separated by a semicolon.
}

\subsection{\code{custom}}{

Custom type. An \code{env_decode} function must be specified for each config
entry of this type, otherwise an error is throw if the corresponding
environment variable is set.
}
}

\section{\code{config$onload_hook()}: pretty-printing configuration}{
Call \code{config$onload_hook()} from the package's \code{.onLoad()} function
if you want to define S3 methods to print the package configuration
nicer.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode">}}\preformatted{config$onload_hook()
}\if{html}{\out{</div>}}
}
}

\section{\code{config$new()}: Create a new configuration}{
Typically \code{new()} is called outside of the functions of the
package, so the \code{config} object is created at install time.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode">}}\preformatted{conf <- config$new(prefix = utils::packageName(parent.frame()))
}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\itemize{
\item \code{prefix}: prefix of the config entry names. For environment
variables it is converted to uppercase, and dots are converted
to underscores. The default prefix is the name of the calling package.
An underscore separator is used between the prefix and the entry
name for environment variable names. A dot separator is used for
R option names.
}
}

\subsection{Value}{

\code{new()} returns a \code{config} object, which is a list containing
the configuration data and functions (methods) to query and change it.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{conf <- config$new()
}\if{html}{\out{</div>}}
}
}

\section{Configuration methods}{
\subsection{\code{conf$add()}: add a new configuration entry}{
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{conf$add(
  name,
  type = conf$types,
  default = NULL,
  check = type[1],
  env_decode = type[1]
)
}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\itemize{
\item \code{name}: name of the entry.
\item \code{type}: type of the entry, string.
\item \code{default}: default value of config entry. If this is a function,
then it is called to generate the default, at the time the
config entry's value is queried.
\item \code{check}: if it is a function, it is called to check the value of
the entry. The function should return \code{TRUE} for successful and
\code{FALSE} for unsuccessful checks. If \code{NULL}, then no check is
performed. It can also be the name of a type, then the default
check for that type is performed, if any.
\item \code{env_decode}: if it is a function, then it is used to decode the
value of the entry from an environment variable, i.e. a string.
It can also be the name of a type, then the \code{env_decode()}
function of that type is used for decoding.
}
}

\subsection{Value}{

The configuration, invisibly.
}

}

\subsection{\code{conf$get()}: query the value of a configuration entry}{
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{conf$get(name)
}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\itemize{
\item \code{name}: name of the entry.
}
}

\subsection{Value}{

Value of the entry.
\itemize{
\item If the entry was set via \code{conf$set()} or \code{conf$update()}, then
that value is returned.
\item Otherwise, if the entry is set via an R option (see
\code{\link[base:options]{base::getOption()}}), then that value is returned. The config
prefix is used to get the option name, with a dot separator.
I.e. for an entry called 'foo', and prefix 'pkg', the \code{pkg.foo}
option is used. If the entry has a check function, that is called
before returning.
\item Otherwise, if the entry is set via an environment variable, then
that value is returned. The config prefix is used to get the name
of the environment variable. In addition, dots are replaced with
underscores and the name is converted to uppercase. I.e. for an
entry called 'foo.bar', and prefix 'pkg', the 'PKG_FOO_BAR`
environment variable is used.
\item Otherwise, if the entry has a default value, that is returned.
The default value might be a function, in which case that function
is called to produce a default value. If the entry has a check
function, that is called before returning.
}
}

}

\subsection{\code{conf$set()}: set the value of a configuration entry}{

If you \verb{$set()} a config entry, then the \code{value} used in \verb{$set()}
will be returned by \verb{$get()}, without consulting R options or
environment variables.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{conf$set(name, value)
}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\itemize{
\item \code{name}: name of the entry.
\item \code{value}: value of the entry. If the entry has a check function,
it is called here.
}
}

\subsection{Value}{

The configuration, invisibly.
}

}

\subsection{\verb{$conf$unset()}: unset a configuration entry}{

Note that this function does \emph{not} unset R options and environment
variables. It merely removes a value that was assigned by \verb{$set()}
or \verb{$update()}.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{conf$unset(name)
}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\itemize{
\item \code{name}: name of the entry.
}
}

\subsection{Value}{

The configuration, invisibly.
}

}

\subsection{\code{cond$update()}: update the values of configuration entries}{

You can use this method to set()\code{and/or}$unset()\verb{multiple config entries.}NULL\verb{values in}new` will unset the corresponding entry.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{conf$update(new)
}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\itemize{
\item \code{new}: named list, where names are config entry names and values
are the corresponding config entry values. \code{NULL} values will
unset the config entry. The list is processed sequentially, so
for duplicates the latest values will be in effect. (But every
value is checked with its check function, if any.)
}
}

\subsection{Value}{

The configuration, invisibly.
}

}

\subsection{\code{conf$list()}: query the names of all config entries}{

Note that their order is non-deterministic currently.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{conf$list()
}\if{html}{\out{</div>}}
}

\subsection{Value}{

Character vector.
}

}

\subsection{\code{conf$exists()}: check if a config entry exists}{
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{conf$exists(name)
}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\itemize{
\item \code{name}: name of the entry.
}
}

\subsection{Value}{

Logical scalar, \code{TRUE} if the entry exists in the configuration,
\code{FALSE} otherwise. Note that \code{TRUE} does not mean that the value
of the entry was set.
}

}

\subsection{\code{conf$lock()}: lock the configuration}{

If a configuration is locked, then no more entries can be added to
it.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{conf$lock()
}\if{html}{\out{</div>}}
}

\subsection{Value}{

The configuration, invisibly.
}

}

\subsection{\code{conf$fix()}: fix the value of a single configuration entry}{

The currently \verb{$set()} value is fixed and cannot be changed any
more. You can fix an entry without setting its value, in which case
R options and environment variables can still be used to update it.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{conf$unset(name)
}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\itemize{
\item \code{name}: name of the entry.
}
}

\subsection{Value}{

The configuration, invisibly.
}

}

\subsection{\code{conf$add_type()}: add a new config entry type to a configuration}{

After this the new type can be used in \code{conf$add()} calls.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{conf$add_type(type_name, check, env_decode)
}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\itemize{
\item \code{type_name}: type name.
\item \code{check}: default check function of the type. Use \code{NULL} for no
checks.
\item \code{env_decode}: function to use to decode a value of the type from
an environment variable (i.e. string).
}
}

\subsection{Value}{

The configuration, invisibly.
}

}
}

\keyword{internal}
