#' @title Solar Light sensors
#'
#' @description A vector of names useful for extracting subsets of spectra from
#'   the \code{\link{sensors.mspct}} object.
#'
#' @format A character vector of names of members of the collection of spectra.
#'
#' @docType data
#' @keywords datasets
#'
#' @details
#' Solar Light UVB biometer model 501 (units with high and low UV-A sensitivity,
#' and a typical unit). Data from an intercomparison.
#'
#' Manufacturer: Solar Light Company, Glenside, PA, U.S.A.
#'
#' @source
#' Data kindly made available by Lasse Ylianttila. These are the responses from
#' a unit with higher and lower response to UVA radiation than typical units,
#' as well as the response for a typical unit as observed in an instrument
#' intercomparison.
#'
#' @references Leszczynski K, Jokela K, Ylianttila L, Visuri R, Blumthaler M.
#' 1997. Report of the WMO/STUK Intercomparison of erythemally-weighted solar UV
#' radiometers (Spring/Summer 1995, Helsinki, Finland). WMO-GAW Report No. 112,
#' 90 pages.
#'
#' Leszczynski K, Jokela K, Ylianttila L, Visuri R, Blumthaler M. 1998.
#' Erythemally weighted radiometers in solar UV monitoring: results from the
#' WMO/STUK Intercomparison. Photochem. Photobiol. 67(2):212-221.
#'
#' \url{https://solarlight.com/product/uvb-biometer-model-501-radiometer/}
#'
#' @examples
#'
#' solarlight_sensors
#'
"solarlight_sensors"
