#' Spectral data for LEDs array supplied by SETi
#'
#' Names of datasets containing the wavelengths and tabulated values spectral emittance
#' for light emitting diodes (LEDs) arrays from SETi.
#' Data are normalized to one at the wavelength of maximum emission.
#'
#' @docType data
#' @keywords datasets
#' @format A vector of character strings.
#'
#' @examples
#' seti
#'
#' @note
#' SETi (Sensor Electronic Technologies) is a supplier of high power ultraviolet
#' LEDs emitting in the UVC, UVB and UVA regions of the spectrum. Many of these
#' LEDs are also sold under different type denominations by Roithner
#' LaserTechnik.
#' 
#' @references \url{http://www.s-et.com/}
#'
#' @seealso \code{\link{leds.mspct}}
#' 
#' @family manufacturers
#' 
"seti"
