% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.classes.r
\name{convertTimeUnit}
\alias{convertTimeUnit}
\title{Convert the "time.unit" attribute of an existing source_spct object}
\usage{
convertTimeUnit(x, time.unit = NULL, ...)
}
\arguments{
\item{x}{source_spct or response_spct object}

\item{time.unit}{a character string, either "second", "hour", "day",
"exposure" or "none", or a lubridate::duration}

\item{...}{(currently ignored)}
}
\value{
x possibly with the \code{time.unit} attribute modified
}
\description{
Function to set the "time.unit" attribute and simultaneously rescaling the
spectral data to be expressed using the new time unit as basis of expression.
The change is done by reference ('in place').
}
\note{
if x is not a \code{source_spct} or a \code{response_spct} object, or
  time.unit is NULL x is returned unchanged, if the existing or new time.unit
  cannot be converted to a duration, then the returned spectrum will contain
  NAs.
}
\examples{

my.spct <- sun.spct
my.spct
convertTimeUnit(my.spct, "day")
my.spct

}
\seealso{
Other time attribute functions: 
\code{\link{checkTimeUnit}()},
\code{\link{getTimeUnit}()},
\code{\link{setTimeUnit}()}
}
\concept{time attribute functions}
