#' @title Theoretical black body
#'
#' @description A dataset for a hypothetical object with transmittance 0/1
#'   (0\%), reflectance 0/1 (0\%)
#'
#' @details \itemize{ \item w.length (nm) \item Tfr (0..1) \item Rfr (0..1) }
#'
#' @docType data
#' @keywords datasets
#' @format A \code{object_spct} object with 4 rows and 3 variables
#' @name black_body.spct
#' @family Spectral data examples
NULL

#' @title Theoretical white body
#'
#' @description A dataset for a hypothetical object with transmittance 0/1
#'   (0\%), reflectance 1/1 (100\%)
#'
#' @details \itemize{ \item w.length (nm) \item Tfr (0..1)  \item Rfr (0..1) }
#'
#' @docType data
#' @keywords datasets
#' @format A \code{object_spct} object with 4 rows and 3 variables
#' @name white_body.spct
#' @family Spectral data examples
NULL

#' @title Theoretical clear body
#'
#' @description A dataset for a hypothetical object with transmittance 1/1
#'   (100\%), reflectance 0/1 (0\%)
#'
#' @details \itemize{ \item w.length (nm) \item Tfr (0..1) \item Rfr (0..1) }
#'
#' @docType data
#' @keywords datasets
#' @format A \code{object_spct} object with 4 rows and 3 variables
#' @name clear_body.spct
#' @family Spectral data examples
NULL
