% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binding.r
\name{binding2to1}
\alias{binding2to1}
\title{Generate a 2:1 Binding Curve}
\usage{
binding2to1(t, t0, conc, kon1, koff1, rmax1, kon2, koff2, rmax2, drift = 0,
  offset = 0, doffset = 0)
}
\arguments{
\item{t}{Time.}

\item{t0}{Time of dissociation.}

\item{conc}{Analyte concentration.}

\item{kon1}{Kon binding constant for first component.}

\item{koff1}{Koff binding constant for first component.}

\item{rmax1}{Maximum response, Rmax, for first component.}

\item{kon2}{Kon binding constant for second component.}

\item{koff2}{Koff binding constant for second component.}

\item{rmax2}{Maximum response, Rmax, for second component.}

\item{drift}{Optional. Parameter to add a linear baseline drift.}

\item{offset}{Optional. Applies a global offset to the response value.}

\item{doffset}{Optional. Applies an offset at the start of dissociation.}
}
\description{
Returns a response value for given parameters at time, t.
}
\examples{
time <- seq(1,2000)
curve <- binding2to1(time,1000,900e-9,10000,0.01,0.4,2000,0.0003,0.5)
plot(curve)
}
\keyword{binding2to1}
