% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_list_tags_for_resource}
\alias{storagegateway_list_tags_for_resource}
\title{Lists the tags that have been added to the specified resource}
\usage{
storagegateway_list_tags_for_resource(ResourceARN, Marker, Limit)
}
\arguments{
\item{ResourceARN}{[required] The Amazon Resource Name (ARN) of the resource for which you want to
list tags.}

\item{Marker}{An opaque string that indicates the position at which to begin returning
the list of tags.}

\item{Limit}{Specifies that the list of tags returned be limited to the specified
number of items.}
}
\description{
Lists the tags that have been added to the specified resource. This
operation is only supported in the cached volume, stored volume and tape
gateway type.
}
\section{Request syntax}{
\preformatted{svc$list_tags_for_resource(
  ResourceARN = "string",
  Marker = "string",
  Limit = 123
)
}
}

\examples{
# Lists the tags that have been added to the specified resource.
\donttest{svc$list_tags_for_resource(
  Limit = 1L,
  Marker = "1",
  ResourceARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-11A2222B"
)}

}
\keyword{internal}
