% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backup_operations.R
\name{backup_delete_recovery_point}
\alias{backup_delete_recovery_point}
\title{Deletes the recovery point specified by a recovery point ID}
\usage{
backup_delete_recovery_point(BackupVaultName, RecoveryPointArn)
}
\arguments{
\item{BackupVaultName}{[required] The name of a logical container where backups are stored. Backup vaults
are identified by names that are unique to the account used to create
them and the AWS Region where they are created. They consist of
lowercase letters, numbers, and hyphens.}

\item{RecoveryPointArn}{[required] An Amazon Resource Name (ARN) that uniquely identifies a recovery point;
for example,
\code{arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45}.}
}
\description{
Deletes the recovery point specified by a recovery point ID.
}
\section{Request syntax}{
\preformatted{svc$delete_recovery_point(
  BackupVaultName = "string",
  RecoveryPointArn = "string"
)
}
}

\keyword{internal}
