% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafv2_operations.R
\name{wafv2_disassociate_web_acl}
\alias{wafv2_disassociate_web_acl}
\title{Disassociates the specified regional application resource from any
existing web ACL association}
\usage{
wafv2_disassociate_web_acl(ResourceArn)
}
\arguments{
\item{ResourceArn}{[required] The Amazon Resource Name (ARN) of the resource to disassociate from the
web ACL.

The ARN must be in one of the following formats:
\itemize{
\item For an Application Load Balancer:
\code{arn:partition:elasticloadbalancing:region:account-id:loadbalancer/app/load-balancer-name/load-balancer-id }
\item For an Amazon API Gateway REST API:
\verb{arn:partition:apigateway:region::/restapis/api-id/stages/stage-name }
\item For an AppSync GraphQL API:
\code{arn:partition:appsync:region:account-id:apis/GraphQLApiId }
\item For an Amazon Cognito user pool:
\code{arn:partition:cognito-idp:region:account-id:userpool/user-pool-id }
\item For an App Runner service:
\code{arn:partition:apprunner:region:account-id:service/apprunner-service-name/apprunner-service-id }
\item For an Amazon Web Services Verified Access instance:
\code{arn:partition:ec2:region:account-id:verified-access-instance/instance-id }
}}
}
\description{
Disassociates the specified regional application resource from any existing web ACL association. A resource can have at most one web ACL association. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance.

See \url{https://www.paws-r-sdk.com/docs/wafv2_disassociate_web_acl/} for full documentation.
}
\keyword{internal}
