% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ram_operations.R
\name{ram_create_permission_version}
\alias{ram_create_permission_version}
\title{Creates a new version of the specified customer managed permission}
\usage{
ram_create_permission_version(
  permissionArn,
  policyTemplate,
  clientToken = NULL
)
}
\arguments{
\item{permissionArn}{[required] Specifies the \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Name (ARN)}
of the customer managed permission you're creating a new version for.}

\item{policyTemplate}{[required] A string in JSON format string that contains the following elements of a
resource-based policy:
\itemize{
\item \strong{Effect}: must be set to \code{ALLOW}.
\item \strong{Action}: specifies the actions that are allowed by this customer
managed permission. The list must contain only actions that are
supported by the specified resource type. For a list of all actions
supported by each resource type, see \href{https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html}{Actions, resources, and condition keys for Amazon Web Services services}
in the \emph{Identity and Access Management User Guide}.
\item \strong{Condition}: (optional) specifies conditional parameters that must
evaluate to true when a user attempts an action for that action to
be allowed. For more information about the Condition element, see
\href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html}{IAM policies: Condition element}
in the \emph{Identity and Access Management User Guide}.
}

This template can't include either the \code{Resource} or \code{Principal}
elements. Those are both filled in by RAM when it instantiates the
resource-based policy on each resource shared using this managed
permission. The \code{Resource} comes from the ARN of the specific resource
that you are sharing. The \code{Principal} comes from the list of identities
added to the resource share.}

\item{clientToken}{Specifies a unique, case-sensitive identifier that you provide to ensure
the idempotency of the request. This lets you safely retry the request
without accidentally performing the same operation a second time.
Passing the same value to a later call to an operation requires that you
also pass the same value for all other parameters. We recommend that you
use a \href{https://en.wikipedia.org/wiki/Universally_unique_identifier}{UUID type of value.}.

If you don't provide this value, then Amazon Web Services generates a
random one for you.

If you retry the operation with the same \code{ClientToken}, but with
different parameters, the retry fails with an
\code{IdempotentParameterMismatch} error.}
}
\description{
Creates a new version of the specified customer managed permission. The new version is automatically set as the default version of the customer managed permission. New resource shares automatically use the default permission. Existing resource shares continue to use their original permission versions, but you can use \code{\link[=ram_replace_permission_associations]{replace_permission_associations}} to update them.

See \url{https://www.paws-r-sdk.com/docs/ram_create_permission_version/} for full documentation.
}
\keyword{internal}
