% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/macie2_operations.R
\name{macie2_get_finding_statistics}
\alias{macie2_get_finding_statistics}
\title{Retrieves (queries) aggregated statistical data about findings}
\usage{
macie2_get_finding_statistics(
  findingCriteria = NULL,
  groupBy,
  size = NULL,
  sortCriteria = NULL
)
}
\arguments{
\item{findingCriteria}{The criteria to use to filter the query results.}

\item{groupBy}{[required] The finding property to use to group the query results. Valid values
are:
\itemize{
\item classificationDetails.jobId - The unique identifier for the
classification job that produced the finding.
\item resourcesAffected.s3Bucket.name - The name of the S3 bucket that the
finding applies to.
\item severity.description - The severity level of the finding, such as
High or Medium.
\item type - The type of finding, such as Policy:IAMUser/S3BucketPublic
and SensitiveData:S3Object/Personal.
}}

\item{size}{The maximum number of items to include in each page of the response.}

\item{sortCriteria}{The criteria to use to sort the query results.}
}
\description{
Retrieves (queries) aggregated statistical data about findings.

See \url{https://www.paws-r-sdk.com/docs/macie2_get_finding_statistics/} for full documentation.
}
\keyword{internal}
