% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_enable_key}
\alias{kms_enable_key}
\title{Sets the key state of a KMS key to enabled}
\usage{
kms_enable_key(KeyId)
}
\arguments{
\item{KeyId}{[required] Identifies the KMS key to enable.

Specify the key ID or key ARN of the KMS key.

For example:
\itemize{
\item Key ID: \verb{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
}

To get the key ID and key ARN for a KMS key, use
\code{\link[=kms_list_keys]{list_keys}} or \code{\link[=kms_describe_key]{describe_key}}.}
}
\description{
Sets the key state of a KMS key to enabled. This allows you to use the KMS key for \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations}{cryptographic operations}.

See \url{https://www.paws-r-sdk.com/docs/kms_enable_key/} for full documentation.
}
\keyword{internal}
