% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acmpca_operations.R
\name{acmpca_issue_certificate}
\alias{acmpca_issue_certificate}
\title{Uses your private certificate authority (CA), or one that has been
shared with you, to issue a client certificate}
\usage{
acmpca_issue_certificate(
  ApiPassthrough = NULL,
  CertificateAuthorityArn,
  Csr,
  SigningAlgorithm,
  TemplateArn = NULL,
  Validity,
  ValidityNotBefore = NULL,
  IdempotencyToken = NULL
)
}
\arguments{
\item{ApiPassthrough}{Specifies X.509 certificate information to be included in the issued
certificate. An \code{APIPassthrough} or \code{APICSRPassthrough} template variant
must be selected, or else this parameter is ignored. For more
information about using these templates, see \href{https://docs.aws.amazon.com/privateca/latest/userguide/UsingTemplates.html}{Understanding Certificate Templates}.

If conflicting or duplicate certificate information is supplied during
certificate issuance, Amazon Web Services Private CA applies \href{https://docs.aws.amazon.com/privateca/latest/userguide/UsingTemplates.html#template-order-of-operations}{order of operation rules}
to determine what information is used.}

\item{CertificateAuthorityArn}{[required] The Amazon Resource Name (ARN) that was returned when you called
\code{\link[=acmpca_create_certificate_authority]{create_certificate_authority}}.
This must be of the form:

\code{arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 }}

\item{Csr}{[required] The certificate signing request (CSR) for the certificate you want to
issue. As an example, you can use the following OpenSSL command to
create the CSR and a 2048 bit RSA private key.

\verb{openssl req -new -newkey rsa:2048 -days 365 -keyout private/test_cert_priv_key.pem -out csr/test_cert_.csr}

If you have a configuration file, you can then use the following OpenSSL
command. The \code{usr_cert} block in the configuration file contains your
X509 version 3 extensions.

\verb{openssl req -new -config openssl_rsa.cnf -extensions usr_cert -newkey rsa:2048 -days 365 -keyout private/test_cert_priv_key.pem -out csr/test_cert_.csr}

Note: A CSR must provide either a \emph{subject name} or a \emph{subject
alternative name} or the request will be rejected.}

\item{SigningAlgorithm}{[required] The name of the algorithm that will be used to sign the certificate to
be issued.

This parameter should not be confused with the \code{SigningAlgorithm}
parameter used to sign a CSR in the
\code{\link[=acmpca_create_certificate_authority]{create_certificate_authority}}
action.

The specified signing algorithm family (RSA or ECDSA) must match the
algorithm family of the CA's secret key.}

\item{TemplateArn}{Specifies a custom configuration template to use when issuing a
certificate. If this parameter is not provided, Amazon Web Services
Private CA defaults to the \code{EndEntityCertificate/V1} template. For CA
certificates, you should choose the shortest path length that meets your
needs. The path length is indicated by the PathLen\emph{N} portion of the
ARN, where \emph{N} is the \href{https://docs.aws.amazon.com/privateca/latest/userguide/PcaTerms.html#terms-cadepth}{CA depth}.

Note: The CA depth configured on a subordinate CA certificate must not
exceed the limit set by its parents in the CA hierarchy.

For a list of \code{TemplateArn} values supported by Amazon Web Services
Private CA, see \href{https://docs.aws.amazon.com/privateca/latest/userguide/UsingTemplates.html}{Understanding Certificate Templates}.}

\item{Validity}{[required] Information describing the end of the validity period of the
certificate. This parameter sets the “Not After” date for the
certificate.

Certificate validity is the period of time during which a certificate is
valid. Validity can be expressed as an explicit date and time when the
certificate expires, or as a span of time after issuance, stated in
days, months, or years. For more information, see
\href{https://datatracker.ietf.org/doc/html/rfc5280#section-4.1.2.5}{Validity}
in RFC 5280.

This value is unaffected when \code{ValidityNotBefore} is also specified. For
example, if \code{Validity} is set to 20 days in the future, the certificate
will expire 20 days from issuance time regardless of the
\code{ValidityNotBefore} value.

The end of the validity period configured on a certificate must not
exceed the limit set on its parents in the CA hierarchy.}

\item{ValidityNotBefore}{Information describing the start of the validity period of the
certificate. This parameter sets the “Not Before" date for the
certificate.

By default, when issuing a certificate, Amazon Web Services Private CA
sets the "Not Before" date to the issuance time minus 60 minutes. This
compensates for clock inconsistencies across computer systems. The
\code{ValidityNotBefore} parameter can be used to customize the “Not Before”
value.

Unlike the \code{Validity} parameter, the \code{ValidityNotBefore} parameter is
optional.

The \code{ValidityNotBefore} value is expressed as an explicit date and time,
using the \code{Validity} type value \code{ABSOLUTE}. For more information, see
\href{https://docs.aws.amazon.com/privateca/latest/APIReference/API_Validity.html}{Validity}
in this API reference and
\href{https://datatracker.ietf.org/doc/html/rfc5280#section-4.1.2.5}{Validity}
in RFC 5280.}

\item{IdempotencyToken}{Alphanumeric string that can be used to distinguish between calls to the
\strong{IssueCertificate} action. Idempotency tokens for \strong{IssueCertificate}
time out after one minute. Therefore, if you call \strong{IssueCertificate}
multiple times with the same idempotency token within one minute, Amazon
Web Services Private CA recognizes that you are requesting only one
certificate and will issue only one. If you change the idempotency token
for each call, Amazon Web Services Private CA recognizes that you are
requesting multiple certificates.}
}
\description{
Uses your private certificate authority (CA), or one that has been shared with you, to issue a client certificate. This action returns the Amazon Resource Name (ARN) of the certificate. You can retrieve the certificate by calling the \code{\link[=acmpca_get_certificate]{get_certificate}} action and specifying the ARN.

See \url{https://www.paws-r-sdk.com/docs/acmpca_issue_certificate/} for full documentation.
}
\keyword{internal}
