% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53recoveryreadiness_service.R
\name{route53recoveryreadiness}
\alias{route53recoveryreadiness}
\title{AWS Route53 Recovery Readiness}
\usage{
route53recoveryreadiness(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e., \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
}}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Recovery readiness
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- route53recoveryreadiness(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical"
  )
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[=route53recoveryreadiness_create_cell]{create_cell} \tab Creates a cell in an account\cr
\link[=route53recoveryreadiness_create_cross_account_authorization]{create_cross_account_authorization} \tab Creates a cross-account readiness authorization\cr
\link[=route53recoveryreadiness_create_readiness_check]{create_readiness_check} \tab Creates a readiness check in an account\cr
\link[=route53recoveryreadiness_create_recovery_group]{create_recovery_group} \tab Creates a recovery group in an account\cr
\link[=route53recoveryreadiness_create_resource_set]{create_resource_set} \tab Creates a resource set\cr
\link[=route53recoveryreadiness_delete_cell]{delete_cell} \tab Delete a cell\cr
\link[=route53recoveryreadiness_delete_cross_account_authorization]{delete_cross_account_authorization} \tab Deletes cross account readiness authorization\cr
\link[=route53recoveryreadiness_delete_readiness_check]{delete_readiness_check} \tab Deletes a readiness check\cr
\link[=route53recoveryreadiness_delete_recovery_group]{delete_recovery_group} \tab Deletes a recovery group\cr
\link[=route53recoveryreadiness_delete_resource_set]{delete_resource_set} \tab Deletes a resource set\cr
\link[=route53recoveryreadiness_get_architecture_recommendations]{get_architecture_recommendations} \tab Gets recommendations about architecture designs for improving resiliency for an application, based on a recovery group\cr
\link[=route53recoveryreadiness_get_cell]{get_cell} \tab Gets information about a cell including cell name, cell Amazon Resource Name (ARN), ARNs of nested cells for this cell, and a list of those cell ARNs with their associated recovery group ARNs\cr
\link[=route53recoveryreadiness_get_cell_readiness_summary]{get_cell_readiness_summary} \tab Gets readiness for a cell\cr
\link[=route53recoveryreadiness_get_readiness_check]{get_readiness_check} \tab Gets details about a readiness check\cr
\link[=route53recoveryreadiness_get_readiness_check_resource_status]{get_readiness_check_resource_status} \tab Gets individual readiness status for a readiness check\cr
\link[=route53recoveryreadiness_get_readiness_check_status]{get_readiness_check_status} \tab Gets the readiness status for an individual readiness check\cr
\link[=route53recoveryreadiness_get_recovery_group]{get_recovery_group} \tab Gets details about a recovery group, including a list of the cells that are included in it\cr
\link[=route53recoveryreadiness_get_recovery_group_readiness_summary]{get_recovery_group_readiness_summary} \tab Displays a summary of information about a recovery group's readiness status\cr
\link[=route53recoveryreadiness_get_resource_set]{get_resource_set} \tab Displays the details about a resource set, including a list of the resources in the set\cr
\link[=route53recoveryreadiness_list_cells]{list_cells} \tab Lists the cells for an account\cr
\link[=route53recoveryreadiness_list_cross_account_authorizations]{list_cross_account_authorizations} \tab Lists the cross-account readiness authorizations that are in place for an account\cr
\link[=route53recoveryreadiness_list_readiness_checks]{list_readiness_checks} \tab Lists the readiness checks for an account\cr
\link[=route53recoveryreadiness_list_recovery_groups]{list_recovery_groups} \tab Lists the recovery groups in an account\cr
\link[=route53recoveryreadiness_list_resource_sets]{list_resource_sets} \tab Lists the resource sets in an account\cr
\link[=route53recoveryreadiness_list_rules]{list_rules} \tab Lists all readiness rules, or lists the readiness rules for a specific resource type\cr
\link[=route53recoveryreadiness_list_tags_for_resources]{list_tags_for_resources} \tab Lists the tags for a resource\cr
\link[=route53recoveryreadiness_tag_resource]{tag_resource} \tab Adds a tag to a resource\cr
\link[=route53recoveryreadiness_untag_resource]{untag_resource} \tab Removes a tag from a resource\cr
\link[=route53recoveryreadiness_update_cell]{update_cell} \tab Updates a cell to replace the list of nested cells with a new list of nested cells\cr
\link[=route53recoveryreadiness_update_readiness_check]{update_readiness_check} \tab Updates a readiness check\cr
\link[=route53recoveryreadiness_update_recovery_group]{update_recovery_group} \tab Updates a recovery group\cr
\link[=route53recoveryreadiness_update_resource_set]{update_resource_set} \tab Updates a resource set
}
}

\examples{
\dontrun{
svc <- route53recoveryreadiness()
svc$create_cell(
  Foo = 123
)
}

}
