% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networkfirewall_operations.R
\name{networkfirewall_create_firewall}
\alias{networkfirewall_create_firewall}
\title{Creates an Network Firewall Firewall and accompanying FirewallStatus for
a VPC}
\usage{
networkfirewall_create_firewall(
  FirewallName,
  FirewallPolicyArn,
  VpcId,
  SubnetMappings,
  DeleteProtection = NULL,
  SubnetChangeProtection = NULL,
  FirewallPolicyChangeProtection = NULL,
  Description = NULL,
  Tags = NULL,
  EncryptionConfiguration = NULL
)
}
\arguments{
\item{FirewallName}{[required] The descriptive name of the firewall. You can't change the name of a
firewall after you create it.}

\item{FirewallPolicyArn}{[required] The Amazon Resource Name (ARN) of the FirewallPolicy that you want to
use for the firewall.}

\item{VpcId}{[required] The unique identifier of the VPC where Network Firewall should create
the firewall.

You can't change this setting after you create the firewall.}

\item{SubnetMappings}{[required] The public subnets to use for your Network Firewall firewalls. Each
subnet must belong to a different Availability Zone in the VPC. Network
Firewall creates a firewall endpoint in each subnet.}

\item{DeleteProtection}{A flag indicating whether it is possible to delete the firewall. A
setting of \code{TRUE} indicates that the firewall is protected against
deletion. Use this setting to protect against accidentally deleting a
firewall that is in use. When you create a firewall, the operation
initializes this flag to \code{TRUE}.}

\item{SubnetChangeProtection}{A setting indicating whether the firewall is protected against changes
to the subnet associations. Use this setting to protect against
accidentally modifying the subnet associations for a firewall that is in
use. When you create a firewall, the operation initializes this setting
to \code{TRUE}.}

\item{FirewallPolicyChangeProtection}{A setting indicating whether the firewall is protected against a change
to the firewall policy association. Use this setting to protect against
accidentally modifying the firewall policy for a firewall that is in
use. When you create a firewall, the operation initializes this setting
to \code{TRUE}.}

\item{Description}{A description of the firewall.}

\item{Tags}{The key:value pairs to associate with the resource.}

\item{EncryptionConfiguration}{A complex type that contains settings for encryption of your firewall
resources.}
}
\description{
Creates an Network Firewall Firewall and accompanying FirewallStatus for a VPC.

See \url{https://www.paws-r-sdk.com/docs/networkfirewall_create_firewall/} for full documentation.
}
\keyword{internal}
