% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ses_operations.R
\name{ses_create_receipt_rule_set}
\alias{ses_create_receipt_rule_set}
\title{Creates an empty receipt rule set}
\usage{
ses_create_receipt_rule_set(RuleSetName)
}
\arguments{
\item{RuleSetName}{[required] The name of the rule set to create. The name must:
\itemize{
\item This value can only contain ASCII letters (a-z, A-Z), numbers (0-9),
underscores (\\_), or dashes (-).
\item Start and end with a letter or number.
\item Contain less than 64 characters.
}}
}
\description{
Creates an empty receipt rule set.
}
\details{
For information about setting up receipt rule sets, see the \href{https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rule-set.html}{Amazon SES Developer Guide}.

You can execute this operation no more than once per second.
}
\section{Request syntax}{
\preformatted{svc$create_receipt_rule_set(
  RuleSetName = "string"
)
}
}

\examples{
\dontrun{
# The following example creates an empty receipt rule set:
svc$create_receipt_rule_set(
  RuleSetName = "MyRuleSet"
)
}

}
\keyword{internal}
