% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_start_outbound_voice_contact}
\alias{connect_start_outbound_voice_contact}
\title{This API places an outbound call to a contact, and then initiates the
contact flow}
\usage{
connect_start_outbound_voice_contact(DestinationPhoneNumber,
  ContactFlowId, InstanceId, ClientToken, SourcePhoneNumber, QueueId,
  Attributes)
}
\arguments{
\item{DestinationPhoneNumber}{[required] The phone number of the customer, in E.164 format.}

\item{ContactFlowId}{[required] The identifier of the contact flow for the outbound call.}

\item{InstanceId}{[required] The identifier of the Amazon Connect instance.}

\item{ClientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. The token is valid for 7 days after
creation. If a contact is already started, the contact ID is returned.
If the contact is disconnected, a new contact is started.}

\item{SourcePhoneNumber}{The phone number associated with the Amazon Connect instance, in E.164
format. If you do not specify a source phone number, you must specify a
queue.}

\item{QueueId}{The queue for the call. If you specify a queue, the phone displayed for
caller ID is the phone number specified in the queue. If you do not
specify a queue, the queue defined in the contact flow is used. If you
do not specify a queue, you must specify a source phone number.}

\item{Attributes}{A custom key-value pair using an attribute map. The attributes are
standard Amazon Connect attributes, and can be accessed in contact flows
just like any other contact attributes.

There can be up to 32,768 UTF-8 bytes across all key-value pairs per
contact. Attribute keys can include only alphanumeric, dash, and
underscore characters.}
}
\description{
This API places an outbound call to a contact, and then initiates the
contact flow. It performs the actions in the contact flow that\'s
specified (in \code{ContactFlowId}).
}
\details{
Agents are not involved in initiating the outbound API (that is, dialing
the contact). If the contact flow places an outbound call to a contact,
and then puts the contact in queue, that\'s when the call is routed to
the agent, like any other inbound case.

There is a 60 second dialing timeout for this operation. If the call is
not connected after 60 seconds, it fails.
}
\section{Request syntax}{
\preformatted{svc$start_outbound_voice_contact(
  DestinationPhoneNumber = "string",
  ContactFlowId = "string",
  InstanceId = "string",
  ClientToken = "string",
  SourcePhoneNumber = "string",
  QueueId = "string",
  Attributes = list(
    "string"
  )
)
}
}

\keyword{internal}
