% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cie.R
\name{cie}
\alias{cie}
\title{CIE colour spaces}
\usage{
cie(vismodeldata, space = c("XYZ", "LAB"))
}
\arguments{
\item{vismodeldata}{(required) quantum catch color data. Can be either the result
from \code{\link{vismodel}} or independently calculated data (in the form of a 
data frame with three columns representing trichromatic viewer).}

\item{space}{(required) Choice between XYZ (1931) or LAB (1971) colour models.}
}
\value{
Object of class \code{colspace} containing:
   \itemize{
     \item \code{X, Y, Z}: Tristimulus values. 
     \item \code{x, y, z}: Cartesian coordinates, when using \code{space = XYZ}.
     \item \code{L, a, b}: Lightness, \code{L}, and colour-opponent \code{a} 
         (redness-greenness) and \code{b} (yellowness-blueness) values, in a 
         Cartesian coordinate space. Returned when using \code{space = LAB}.
   }
}
\description{
Calculates coordinates and colorimetric variables that represent reflectance spectra
in either the CIEXYZ (1931) or CIELAB (1971) colourspaces.
}
\examples{
\dontrun{
data(flowers)
vis.flowers <- vismodel(flowers, visual = 'cie10', illum = 'D65')
flowers.ciexyz <- colspace(vis.flowers, space = 'ciexyz')
flowers.cielab <- colspace(vis.flowers, space = 'cielab')
}

}
\author{
Thomas White \email{thomas.white026@gmail.com}
}
\references{
Smith T, Guild J. (1932) The CIE colorimetric standards and their use.
   Transactions of the Optical Society, 33(3), 73-134.

Westland S, Ripamonti C, Cheung V. (2012). Computational colour science 
   using MATLAB. John Wiley & Sons.

Stockman, A., & Sharpe, L. T. (2000). Spectral sensitivities of 
 the middle- and long-wavelength sensitive cones derived from measurements in 
 observers of known genotype. Vision Research, 40, 1711-1737.

CIE (2006). Fundamental chromaticity diagram with physiological axes. 
 Parts 1 and 2. Technical Report 170-1. Vienna: Central Bureau of the Commission 
 Internationale de l Eclairage.
}
\keyword{internal}

