% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bag_tree_C5.0.R
\name{details_bag_tree_C5.0}
\alias{details_bag_tree_C5.0}
\title{Bagged trees via C5.0}
\description{
\code{\link[baguette:bagger]{baguette::bagger()}} creates an collection of decision trees forming an
ensemble. All trees in the ensemble are combined to produce a final prediction.
}
\details{
For this engine, there is a single mode: classification
\subsection{Tuning Parameters}{

This model has 1 tuning parameters:
\itemize{
\item \code{min_n}: Minimal Node Size (type: integer, default: 2L)
}
}

\subsection{Translation from parsnip to the original package (classification)}{

The \strong{baguette} extension package is required to fit this model.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(baguette)

bag_tree(min_n = integer()) |> 
  set_engine("C5.0") |> 
  set_mode("classification") |> 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Bagged Decision Tree Model Specification (classification)
## 
## Main Arguments:
##   cost_complexity = 0
##   min_n = integer()
## 
## Computational engine: C5.0 
## 
## Model fit template:
## baguette::bagger(x = missing_arg(), y = missing_arg(), weights = missing_arg(), 
##     minCases = integer(), base_model = "C5.0")
}\if{html}{\out{</div>}}
}

\subsection{Preprocessing requirements}{

This engine does not require any special encoding of the predictors.
Categorical predictors can be partitioned into groups of factor levels
(e.g. \verb{\{a, c\}} vs \verb{\{b, d\}}) when splitting at a node. Dummy variables
are not required for this model.
}

\subsection{Case weights}{

This model can utilize case weights during model fitting. To use them,
see the documentation in \link{case_weights} and the examples
on \code{tidymodels.org}.

The \code{fit()} and \code{fit_xy()} arguments have arguments called
\code{case_weights} that expect vectors of case weights.
}

\subsection{References}{
\itemize{
\item Breiman, L. 1996. “Bagging predictors”. Machine Learning. 24 (2):
123-140
\item Kuhn, M, and K Johnson. 2013. \emph{Applied Predictive Modeling}. Springer.
}
}
}
\keyword{internal}
