% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ambiorix.R
\name{scaffold_ambiorix}
\alias{scaffold_ambiorix}
\title{Ambiorix}
\usage{
scaffold_ambiorix(vue = FALSE, use_cdn = TRUE, edit = interactive())
}
\arguments{
\item{vue}{Whether to include Vue, internally runs \code{\link[=apply_vue]{apply_vue()}} and
adapts the \code{srcjs/index.js} template for Vue.}

\item{use_cdn}{Whether to use the CDN for react or vue dependencies,
this is passed to \code{\link[=apply_react]{apply_react()}} or \code{\link[=apply_vue]{apply_vue()}} if \code{react} or
\code{vue} arguments are set to \code{TRUE} and ignored otherwise.}

\item{edit}{Automatically open pertinent files.}
}
\value{
\code{TRUE} (invisibly) if successfully run.
}
\description{
Creates the basic structure for an ambiorix application.
}
\details{
Only one of \code{react} or \code{vue} can be set to \code{TRUE}.
}
\examples{
if(interactive()){
# current directory
wd <- getwd()

# create a mock up ambiorix project
tmp <- tmp_ambiorix()

# move to package
setwd(tmp)

# scaffold ambiorix
scaffold_ambiorix()

# clean up
setwd(wd)
tmp_delete(tmp)
}

}
