% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selyear.R
\name{selyear}
\alias{selyear}
\alias{selyear,Raster-method}
\alias{selyear,data.table-method}
\alias{selyear,character-method}
\title{Select Years}
\usage{
selyear(x, y)

\S4method{selyear}{Raster}(x, y)

\S4method{selyear}{data.table}(x, y)

\S4method{selyear}{character}(x, y)
}
\arguments{
\item{x}{Raster* object; data.table (see details); filename (character, see details)}

\item{y}{numeric. Time range in the form: (start_year, end_year)}
}
\value{
Raster* object; data.table
}
\description{
The function \code{selyear} subsets the data in time within a year range.
}
\details{
If `x` is a data.table, its columns should be named: "lon", "lat", "date", and "value"

If `x` is a filename, it should point to a *.nc file.
}
\examples{
\dontrun{
download_data("gldas-vic", tempdir(), timestep = "yearly")
r <- raster::brick(paste0(tempdir(),
"/gldas-vic_tp_mm_land_194801_201412_025_yearly.nc"))
s <- selyear(r, c(2000, 2010))
}
}
\keyword{internal}
