% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fldmean.R
\name{fldmean}
\alias{fldmean}
\alias{fldmean,Raster-method}
\alias{fldmean,data.table-method}
\alias{fldmean,character-method}
\title{Field mean}
\usage{
fldmean(x)

\S4method{fldmean}{Raster}(x)

\S4method{fldmean}{data.table}(x)

\S4method{fldmean}{character}(x)
}
\arguments{
\item{x}{Raster* object; data.table (see details); filename (character, see details)}
}
\value{
data.table
}
\description{
The function \code{fldmean} computes the spatial weighted average for each timestep.
}
\details{
If `x` is a data.table, its columns should be named: "lon", "lat", "date", and "value"

If `x` is a filename, it should point to a *.nc file.
}
\examples{
\dontrun{
download_data("gldas-vic", tempdir(), timestep = "yearly")
r <- raster::brick(paste0(tempdir(),
"/gldas-vic_tp_mm_land_194801_201412_025_yearly.nc"))
s <- fldmean(r)
}
}
