% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{print.osrm_job}
\alias{print.osrm_job}
\title{Print summary for an \code{osrm_job} object}
\usage{
\method{print}{osrm_job}(x, ...)
}
\arguments{
\item{x}{An \code{osrm_job} object.}

\item{...}{Passed to methods; currently ignored.}
}
\value{
Invisibly returns \code{x}.
}
\description{
Displays pipeline state, outputs, and next steps for an \code{osrm_job} returned
by functions such as \code{\link[=osrm_extract]{osrm_extract()}}, \code{\link[=osrm_prepare_graph]{osrm_prepare_graph()}}, \code{\link[=osrm_partition]{osrm_partition()}},
or \code{\link[=osrm_contract]{osrm_contract()}}.
}
\examples{
\donttest{
if (identical(Sys.getenv("OSRM_EXAMPLES"), "true")) {
  install_dir <- osrm_install(
    version = "latest",
    path_action = "session",
    quiet = TRUE
  )

  # copy example OSM PBF into a temporary workspace to avoid polluting pkg data
  pbf_path <- system.file("extdata/cur.osm.pbf", package = "osrm.backend")
  osrm_dir <- file.path(tempdir(), paste0("osrm-", Sys.getpid()))
  dir.create(osrm_dir, recursive = TRUE)
  tmp_pbf <- file.path(osrm_dir, "cur.osm.pbf")
  file.copy(from = pbf_path, to = tmp_pbf, overwrite = TRUE)

  job <- osrm_prepare_graph(tmp_pbf, overwrite = TRUE, threads = 1L)
  print(job)

  osrm_uninstall(
    dest_dir = install_dir,
    clear_path = TRUE,
    force = TRUE,
    quiet = TRUE
  )
  unlink(osrm_dir, recursive = TRUE)
}
}
}
\keyword{internal}
