% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setpar.R
\name{setpar}
\alias{setpar}
\title{Setting \code{\link{par}()} plotting parameters}
\usage{
setpar(tmpl = "ts", mfrow = c(1, 1), ...)
}
\arguments{
\item{tmpl}{The name of the parameter template, give "ts" as default}

\item{mfrow}{The mfrow for \code{par}.}

\item{...}{More parameters for \code{par}.}
}
\value{
Return the original set of parameters, such that they can be reset after plotting.
}
\description{
Setting \code{\link{par}()} plotting parameters to a set of default values
}
\details{
A simple function, which sets the \code{\link{par}()} plotting parameters to a default set of values.

Actually, only really used for setting useful \code{par} values for multiple time series plots with same x-axis.
Give \code{tmpl="ts"} and \code{mfrow=c(x,1)}, where x is the number of plots.
}
\examples{

# Make some data
D <- data.frame(t=seq(ct("2020-01-01"),ct("2020-01-10"),len=100), x=rnorm(100), y=runif(100))
# Remember the currect par values
oldpar <- setpar()

# Generate two stacked plots with same x-axis
setpar("ts", mfrow=c(2,1))
plot(D$t, D$x, type="l")
plot(D$t, D$y, type="l")
# Note xaxt="s" must be set
axis.POSIXct(1, D$t, xaxt="s", format="\%Y-\%m-\%d")

# Set back the par to the previous
par(oldpar)

# In a function, where this is used and a plot is generated,
# then do like this in order to automatically reset on exit
oldpar <- setpar(mfrow=c(2,1))
on.exit(par(oldpar))        

}
