% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resample.R
\name{resample}
\alias{resample}
\title{Resampling to equidistant time series}
\usage{
resample(
  object,
  ts,
  tstart = NA,
  tend = NA,
  timename = "t",
  fun = mean,
  quantizetime = TRUE,
  ...
)
}
\arguments{
\item{object}{Can be data.frame}

\item{ts}{(numeric) New sample period in seconds}

\item{tstart}{A POSIXxx (or charater or numeric), which indicates the first time point in the series returned}

\item{tend}{A POSIXxx (or charater or numeric), which indicates the last time point in the series returned}

\item{timename}{(character) The name of the time column in object}

\item{fun}{(function) The function of apply. Default is mean, such that average values are obtained}

\item{quantizetime}{(logical) Should the new time points be set to the end of the time intervals, or should they also be the result of the fun function}

\item{...}{Passed on to the fun function}
}
\value{
A downsampled data.frame
}
\description{
Make a downsampling to a lower sampling frequency
}
\details{
Given an object with a column indicating the time points of the observations the
function returns a similar object, where the function is applied for each new (and longer)
interval.

Typically it is used if for example 15 minute values should be made into 1 hour values.

NOTE that it is always assumed that the time point is at the end of the time interval,
e.g. if hourly values are returned, then "2019-01-01 01:00" indicates the first hour in 2019.

All time points at the time point (border) of between two intervals is assigned to the
first interval of the two.
}
\examples{

# Generate some test data with 10 minutes sampling frequency for one day
X <- data.frame(t=seq(ct("2019-01-01 00:10"),ct("2019-01-02"), by=10*60))

# A single sine over the day
X$val <- sin(as.numeric(X$t)/3600*2*pi/(24))

# Resample to hourly average values
Xre <- resample(X, 3600)
plot(X$t, X$val)
lines(Xre$t, Xre$val, type="b", col=2)

# Resample to hourly max values
Xre <- resample(X, 3600, fun=max)
lines(Xre$t, Xre$val, type="b", col=3)

# Another starting time point
Xre <- resample(X, 3600, tstart="2019-01-01 00:30")
lines(Xre$t, Xre$val, type="b", col=4)


}
