% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onetime.R
\name{onetime_do}
\alias{onetime_do}
\title{Run code only once}
\usage{
onetime_do(
  expr,
  id = calling_package(),
  path = default_lockfile_dir(),
  expiry = NULL,
  default = NULL,
  without_permission = c("warn", "run", "stop", "pass", "ask")
)
}
\arguments{
\item{expr}{The code to evaluate. An R statement or \code{\link[=expression]{expression()}} object.}

\item{id}{Unique ID string. By default, name of the calling package.}

\item{path}{Directory to store lockfiles.}

\item{expiry}{\code{\link[=difftime]{difftime()}} or e.g. \code{\link[lubridate:duration]{lubridate::duration()}} object.
After this length of time, code will be run again.}

\item{default}{Value to return if \code{expr} was not executed.}

\item{without_permission}{Character string. What to do if the user hasn't
given permission to store files? \code{"warn"} runs the action with an extra
warning; \code{"run"} runs the action; \code{"pass"} does nothing and returns the
default; \code{"stop"} throws an error; \code{"ask"} asks for permission, after
running the action but before recording it on disk.}
}
\value{
The value of \code{expr}, invisibly; or \code{default} if \code{expr} was not run
because it had been run already.
}
\description{
This function runs an expression just once. It then creates a lockfile
recording a unique ID which will prevent the expression being run again.
}
\details{
Calls are identified by \code{id}. If you use the same value of \code{id} across
different calls to \code{onetime_do()} and similar functions, only the first
call will get made.

By default, \code{id} is just the name of the calling package. This is for the
common use case of a single call within a package (e.g. at first startup).
If you want to use multiple calls, or if the calling code is not within a
package, then you \emph{must} set \code{id} explicitly. If you are working in a
large project with many contributors, it is \emph{strongly recommended to set}
\code{id } \emph{explicitly}.

The default \code{path}, where lockfiles are stored, is within
\code{\link[rappdirs:user_data_dir]{rappdirs::user_config_dir()}} unless overridden by \code{options("onetime.dir")}.
If the lockfile cannot be written (e.g. because the user has not given
permission to store files on his or her computer), then the call will still
be run, so it may be run repeatedly. Conversely, if the call gives an error,
the lockfile is still written.
}
\examples{
oo <- options(onetime.dir = tempdir(check = TRUE))
id <- sample(10000L, 1L)

for (n in 1:3) {
  onetime_do(print("printed once"), id = id)
}

onetime_reset(id = id)
options(oo)
}
