% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power.2m.mod.R
\name{power.2m.mod}
\alias{power.2m.mod}
\title{Statistical power, sample size (and/or budget), minimum detectable moderator
effect size calculation for two-level multisite randomized trials (MRTs)
detecting moderation effects}
\usage{
power.2m.mod(
  cost.model = TRUE,
  expr = NULL,
  constraint = NULL,
  sig.level = 0.05,
  two.tailed = TRUE,
  omega = NULL,
  gamma = NULL,
  power.mod = NULL,
  m = NULL,
  n = NULL,
  J = NULL,
  p = NULL,
  icc = NULL,
  r12 = NULL,
  r22m = NULL,
  q.mod = 1,
  c1 = NULL,
  c2 = NULL,
  c1t = NULL,
  gammalim = c(0, 5),
  powerlim = c(1e-10, 1 - 1e-10),
  Jlim = c(2.5, 1e+10),
  mod.level = 1,
  binary = TRUE,
  mlim = NULL,
  rounded = TRUE,
  Q = 0.5
)
}
\arguments{
\item{cost.model}{Logical; power analyses accommodating costs and budget
(e.g., required budget for desired power, power/MDES under fixed budget)
if TRUE, otherwise conventional power analyses
(e.g., required sample size, power, or MDES calculation); default value is TRUE.}

\item{expr}{Returned objects from function \code{\link{od.2m.mod}}; default is NULL;
if \code{expr} is specified, parameter values of \code{icc},
\code{r12}, \code{r22m},
\code{c1}, \code{c2},
\code{c1t}, \code{p}, and \code{n}
used or solved in function \code{\link{od.2m.mod}} will
be passed to the current function;
only the values of \code{p} and \code{n} that specified or solved in
function \code{\link{od.2m.mod}} can be overwritten
if \code{constraint} is specified.}

\item{constraint}{Specify the constrained values of \code{p} and/or \code{n}
in list format to overwrite those from \code{expr}; default value is NULL.}

\item{sig.level}{Significance level or type I error rate, default value is 0.05.}

\item{two.tailed}{Logical; two-tailed tests if TRUE,
otherwise one-tailed tests; default value is TRUE.}

\item{omega}{The treatment-by-site variance of the outcome.}

\item{gamma}{The standardized moderated treatment effect.}

\item{power.mod}{Statistical power for the moderation
effect. The default is .80.}

\item{m}{Total budget, default is the total costs of sampling 60
sites.}

\item{n}{The level-1 sample size per level-2 unit.}

\item{J}{The number of sites.}

\item{p}{The proportion of level-1 units within each level 2 unit
to be assigned to treatment.}

\item{icc}{The unconditional intraclass correlation coefficient (ICC) in population or in
each treatment condition.}

\item{r12}{The proportion of level-1 variance explained by covariates.}

\item{r22m}{The proportion of variance of site-specific treatment
effect explained by covariates.}

\item{q.mod}{The number of predictors at the moderator level
in the moderation model.}

\item{c1}{The cost of sampling one level-1 unit in control condition.}

\item{c2}{The cost of sampling one level-2 unit (site).}

\item{c1t}{The cost of sampling one level-1 unit in treatment condition.}

\item{gammalim}{The range for numerically solving the root of standardized
moderation effect (gamma). Default is c(0, 5).}

\item{powerlim}{The range for solving the root of power (\code{power}) numerically,
default value is c(1e-10, 1 - 1e-10).}

\item{Jlim}{The range for solving the root of level-2 sample size
(\code{J}) numerically. Change the default values to a larger range
(e.g., starting with a smaller value) if
f() values at end points are not of opposite sign. For example,
use Jlim = c(1.5, 1e10).}

\item{mod.level}{The level of the moderator is at. The moderator is at level 1
if mod.level is 1, and at level 2 if mod.level is 2. The default is
mod.level = 1.}

\item{binary}{Logical; The moderator is binary if TRUE, and continuous if
FALSE. The default is TRUE.}

\item{mlim}{The range for numerically solving the root of budget (\code{m}).
The default is NULL, which mlim = Jlim times the costs for each site and
its members.}

\item{rounded}{Logical; round the values of \code{p}, \code{n}/\code{J}/\code{K}
that are from functions \code{\link{od.4}}
to two decimal places and integer, respectively if TRUE,
otherwise no rounding; default value is TRUE.}

\item{Q}{The proportion of units in one group for the binary moderator.
Default is 0.5.}

\item{power}{Statistical power.mod for a moderation effect.}
}
\value{
Required budget (and/or required level-2 sample size), statistical power, or MDES
    depending on the specification of parameters.
    The function also returns the function name, design type,
    and parameters used in the calculation.
}
\description{
This function can calculate power, required sample size/budget
    for desired power, or minimum detectable moderation effect size (MDMES)
    under a fixed budget in two-level MRTs.
    It also can perform conventional power analyses
    (e.g., required sample size, power, and MDMES calculation).
}
\examples{
myod <- od.2m.mod(icc = .2, r12 = .5, r22m = .5,
                   c1 = 10, c1t = 100, c2 = 50,
                   omega = .01, gamma = 0.1)
mypower <- power.2m.mod(expr = myod, m=myod$out$m, gamma = 0.1); mypower$out
mym <- power.2m.mod(expr = myod, power.mod = .80, gamma = 0.1); mym$out
myod <- od.2m.only.mod(icc = .2, r12 = .5, r22m = .5,
                       c1 = 10, c1t = 100, c2 = 50, omega = .01)
mypower <- power.2m.mod(expr = myod, power.mod = .8, gamma = 0.1)
mypower$out

}
