% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{duplicatesexcludeAnalysis}
\alias{duplicatesexcludeAnalysis}
\title{Duplicated records}
\usage{
duplicatesexcludeAnalysis(
  df,
  xf,
  yf,
  resolution.in.minutes,
  raster.grid = NULL,
  verbose = FALSE
)
}
\arguments{
\item{df}{Data.frame of species occurrences}

\item{xf}{the field in the data frame containing the x coordinators}

\item{yf}{the field in the data frame containing the y coordinates}

\item{resolution.in.minutes}{the resolution of environmental data used, specified in minutes}

\item{raster.grid}{An optional raster grid}

\item{verbose}{logical. Print messages? Default FALSE}
}
\value{
list of three components: Dups.Exact = exact duplicate records, Dups.Grid= duplicates within environmental gridcell, continue = dataframe with good records
}
\description{
Duplicated records
}
\details{
it differentiates the exact duplicates and the duplicates for a occurrences falling in the same pixel
}
\examples{
k <- data.frame (x=c(runif (n = 100),1000),y=c(runif (n = 100),1000),Reason=NA)
duplicatesexcludeAnalysis(k,xf='x',yf='y',resolution.in.minutes=60)
}
\seealso{
Other analysis: 
\code{\link{.nearestcell3}()},
\code{\link{centroidDetection}()},
\code{\link{countryStatusRangeAnalysis}()},
\code{\link{geoEnvAccuracy}()},
\code{\link{humanDetection}()}
}
\author{
Josep M Serra-Diaz (pep.serradiaz@agroparistech.fr)
}
\concept{analysis}
\keyword{internal}
