% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deleteParticipant.R
\name{deleteParticipant}
\alias{deleteParticipant}
\title{Deletes a participant record.}
\usage{
deleteParticipant(labbcat.url, id)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{id}{The participant ID - either the unique internal database ID, or their name.}
}
\value{
TRUE if the participant's record was delete, FALSE otherwise.
}
\description{
This function deletes the identified participant from the corpus, but only if they do
not appear in any transcripts.
}
\examples{
\dontrun{
## define the LaBB-CAT URL
labbcat.url <- "https://labbcat.canterbury.ac.nz/demo/"

## Create a new participant record
saveParticipant(labbcat.url, "Juan Perez")

### Delete the participant we just created
deleteParticipant(labbcat.url, "Juan Perez")
}

}
\seealso{
\code{\link{getParticipant}}
  \code{\link{saveParticipant}}
}
\keyword{participant}
