% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lin.R
\name{lin}
\alias{lin}
\title{Lin (LIN) Measure}
\usage{
lin(data, var.weights = NULL)
}
\arguments{
\item{data}{A data.frame or a matrix with cases in rows and variables in columns.}

\item{var.weights}{A numeric vector setting weights to the used variables. One can choose the real numbers from zero to one.}
}
\value{
The function returns an object of the class "dist".
\cr
}
\description{
The function calculates a dissimilarity matrix based on the LIN similarity measure.
}
\details{
The Lin measure was introduced by Lin (1998) and presented in (Boriah et al., 2008).
The measure assigns higher weights to more frequent categories in case of matches
and lower weights to less frequent categories in case of mismatches.
}
\examples{
# sample data
data(data20)

# dissimilarity matrix calculation
prox.lin <- lin(data20)

# dissimilarity matrix calculation with variable weights
weights.lin<- lin(data20, var.weights = c(0.7, 1, 0.9, 0.5, 0))

}
\references{
Boriah S., Chandola V., Kumar V. (2008). Similarity measures for categorical data: A comparative evaluation.
In: Proceedings of the 8th SIAM International Conference on Data Mining, SIAM, p. 243-254.
 \cr
 \cr
Lin D. (1998). An information-theoretic definition of similarity.
In: ICML '98: Proceedings of the 15th International Conference on Machine Learning. San Francisco, p. 296-304.
}
\seealso{
\code{\link[nomclust]{anderberg}},
\code{\link[nomclust]{burnaby}},
\code{\link[nomclust]{eskin}},
\code{\link[nomclust]{gambaryan}},
\code{\link[nomclust]{goodall1}},
\code{\link[nomclust]{goodall2}},
\code{\link[nomclust]{goodall3}},
\code{\link[nomclust]{goodall4}},
\code{\link[nomclust]{iof}},
\code{\link[nomclust]{lin1}},
\code{\link[nomclust]{of}},
\code{\link[nomclust]{sm}},
\code{\link[nomclust]{smirnov}},
\code{\link[nomclust]{ve}},
\code{\link[nomclust]{vm}}.
}
\author{
Zdenek Sulc. \cr Contact: \email{zdenek.sulc@vse.cz}
}
