% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/003functions.R
\name{LL_joint}
\alias{LL_joint}
\title{\code{LL_joint} Function for joint log-likelihood with correlation between
 continuous and discrete equations}
\usage{
LL_joint(
  ffor,
  cheqs0,
  objm = NULL,
  datan = "data",
  cfunc = "cfunc",
  cgrad = "cgrad",
  chess = "chess",
  gfunc = "gfunc",
  hfunc = "hfunc",
  check_hess = FALSE,
  print_out = FALSE,
  bayesian_random = FALSE,
  MNtypef = "logit"
)
}
\arguments{
\item{ffor}{Discrete equations.}

\item{cheqs0}{Continuous equations.}

\item{objm}{Expressions from \code{cond_mean_cov_expr}.}

\item{datan}{Character string. Name of data-set.}

\item{cfunc}{Character string. Name for continuous block function.}

\item{cgrad}{Character string. Name for continuous block gradient.}

\item{chess}{Character string. Name for continuous block hessian.}

\item{gfunc}{Character string. Name for joint gradient.}

\item{hfunc}{Character string.  Name for joint Hessian.}

\item{check_hess}{if \code{TRUE}, Hessian is checked.}

\item{print_out}{if \code{TRUE}, prints out LL for each equation.}

\item{bayesian_random}{If \code{TRUE}, than par[1] is changed to par[,1] to be used for 
optimization of random parameters in Bayesian estimation.}

\item{MNtypef}{"logit" or "dogit".}
}
\value{
Function for joint estimation
}
\description{
\code{LL_joint} Function for joint log-likelihood with correlation between
 continuous and discrete equations
}
\keyword{internal}
