% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSquadp.R
\name{SSquadp}
\alias{SSquadp}
\alias{quadp}
\title{self start for quadratic-plateau function}
\usage{
quadp(x, a, b, c, xs)

SSquadp(x, a, b, c, xs)
}
\arguments{
\item{x}{input vector}

\item{a}{the intercept}

\item{b}{the slope}

\item{c}{quadratic term}

\item{xs}{break point of transition between quadratic and plateau}
}
\value{
a numeric vector of the same length as x containing parameter estimates for equation specified

quadp: vector of the same length as x using the quadratic-plateau function
}
\description{
Self starter for quadratic plateau function with parameters a (intercept), b (slope), c (quadratic), xs (break-point)
}
\details{
Reference for nonlinear regression Archontoulis and Miguez (2015) - (doi:10.2134/agronj2012.0506).
}
\examples{
\donttest{
require(ggplot2)
set.seed(123)
x <- 1:30
y <- quadp(x, 5, 1.7, -0.04, 20) + rnorm(30, 0, 0.6)
dat <- data.frame(x = x, y = y)
fit <- nls(y ~ SSquadp(x, a, b, c, xs), data = dat, algorithm = "port")
## plot
ggplot(data = dat, aes(x = x, y = y)) + 
  geom_point() + 
  geom_line(aes(y = fitted(fit)))
}
}
