% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSplin.R
\name{SSplin}
\alias{SSplin}
\alias{plin}
\title{self start for plateau-linear function}
\usage{
plin(x, a, xs, b)

SSplin(x, a, xs, b)
}
\arguments{
\item{x}{input vector}

\item{a}{the initial plateau}

\item{xs}{break-point of transition between plateau and linear}

\item{b}{the slope}
}
\value{
a numeric vector of the same length as x containing parameter estimates for equation specified

plin: vector of the same length as x using the plateau-linear function
}
\description{
Self starter for plateau-linear function with parameters a (plateau), xs (break-point), b (slope)
}
\details{
Initial plateau with a second linear phase. When \eqn{x < xs: y = a} and when \eqn{x >= xs: y = a + b * (x - xs)}.
}
\examples{
\donttest{
require(ggplot2)
set.seed(123)
x <- 1:30
y <- plin(x, 10, 20, 1) + rnorm(30, 0, 0.5)
dat <- data.frame(x = x, y = y)
fit <- nls(y ~ SSplin(x, a, xs, b), data = dat)
## plot
ggplot(data = dat, aes(x = x, y = y)) + 
  geom_point() + 
  geom_line(aes(y = fitted(fit)))
## Confidence intervals
confint(fit)
}

}
